/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectionProbe;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.Transport;

public abstract class AbstractSocketConnectorHandler
implements SocketConnectorHandler {
    protected Transport transport;
    private Processor processor;
    private ProcessorSelector processorSelector;
    protected final Collection<ConnectionProbe> probes = new LinkedList<ConnectionProbe>();

    public AbstractSocketConnectorHandler(Transport transport) {
        this.transport = transport;
        this.processor = transport.getProcessor();
        this.processorSelector = transport.getProcessorSelector();
    }

    public GrizzlyFuture<Connection> connect(String host, int port) throws IOException {
        return this.connect(new InetSocketAddress(host, port));
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) throws IOException {
        return this.connect(remoteAddress, (SocketAddress)null);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) throws IOException {
        return this.connect(remoteAddress, (SocketAddress)null, (CompletionHandler)completionHandler);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        return this.connect(remoteAddress, localAddress, (CompletionHandler)null);
    }

    public abstract GrizzlyFuture<Connection> connect(SocketAddress var1, SocketAddress var2, CompletionHandler<Connection> var3) throws IOException;

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector processorSelector) {
        this.processorSelector = processorSelector;
    }

    @Override
    public void addMonitoringProbe(ConnectionProbe probe) {
        this.probes.add(probe);
    }

    @Override
    public boolean removeMonitoringProbe(ConnectionProbe probe) {
        return this.probes.remove(probe);
    }

    @Override
    public ConnectionProbe[] getMonitoringProbes() {
        return this.probes.toArray(new ConnectionProbe[this.probes.size()]);
    }

    protected void preConfigure(Connection connection) {
    }
}

