/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransportFactory;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.util.LinkedTransferQueue;

public class IdleTimeoutFilter
extends FilterAdapter {
    public static final long UNLIMITED_TIMEOUT = -1L;
    public static final long UNSET_TIMEOUT = 0L;
    public static final String IDLE_ATTRIBUTE_NAME = "connection-idle-attribute";
    public static Attribute<Long> idleAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("connection-idle-attribute", -1L);
    private boolean isHandleAccepted;
    private boolean isHandleConnected;
    private volatile ScheduledFuture scheduledFuture;
    private long timeoutMillis;
    private ScheduledExecutorService scheduledThreadPool;
    private LinkedTransferQueue<Connection> connections;
    private volatile TimeoutChecker checker;

    public IdleTimeoutFilter(long timeout, TimeUnit timeunit) {
        this(timeout, timeunit, TransportFactory.getInstance().getDefaultScheduledThreadPool());
    }

    public IdleTimeoutFilter(long timeout, TimeUnit timeunit, ScheduledExecutorService scheduledThreadPool) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        this.scheduledThreadPool = scheduledThreadPool;
        this.connections = new LinkedTransferQueue();
        this.isHandleAccepted = true;
        this.isHandleConnected = false;
    }

    public ScheduledExecutorService getScheduledThreadPool() {
        return this.scheduledThreadPool;
    }

    public void setScheduledThreadPool(ScheduledExecutorService scheduledThreadPool) {
        this.scheduledThreadPool = scheduledThreadPool;
    }

    public long getTimeout(TimeUnit timeunit) {
        return timeunit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void setTimeout(long timeout, TimeUnit timeunit) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        if (this.scheduledFuture == null) {
            this.scheduledFuture.cancel(false);
            this.registerChecker();
        }
    }

    public boolean isHandleAccepted() {
        return this.isHandleAccepted;
    }

    public void setHandleAccepted(boolean isHandleAccepted) {
        this.isHandleAccepted = isHandleAccepted;
    }

    public boolean isHandleConnected() {
        return this.isHandleConnected;
    }

    public void setHandleConnected(boolean isHandleConnected) {
        this.isHandleConnected = isHandleConnected;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        this.clearTimeout(ctx.getConnection());
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        this.clearTimeout(ctx.getConnection());
        return nextAction;
    }

    @Override
    public NextAction postRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        this.resetTimeout(ctx.getConnection());
        return nextAction;
    }

    @Override
    public NextAction postWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        this.resetTimeout(ctx.getConnection());
        return nextAction;
    }

    @Override
    public NextAction postAccept(FilterChainContext ctx, NextAction nextAction) throws IOException {
        if (this.isHandleAccepted) {
            Connection connection = ctx.getConnection();
            this.resetTimeout(connection);
            this.addConnection(connection);
        }
        return nextAction;
    }

    @Override
    public NextAction postConnect(FilterChainContext ctx, NextAction nextAction) throws IOException {
        if (this.isHandleConnected()) {
            Connection connection = ctx.getConnection();
            this.resetTimeout(connection);
            this.addConnection(connection);
        }
        return nextAction;
    }

    public synchronized void initialize() {
        if (this.scheduledFuture != null) {
            throw new IllegalStateException("IdleTimeoutFilter was already initialized!");
        }
        this.registerChecker();
    }

    public synchronized void release() {
        this.checker = null;
        this.scheduledFuture.cancel(false);
        this.scheduledFuture = null;
        this.connections.clear();
    }

    protected void registerChecker() {
        if (this.timeoutMillis > 0L) {
            this.checker = new TimeoutChecker();
            this.scheduledFuture = this.scheduledThreadPool.schedule(this.checker, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    protected void addConnection(Connection connection) {
        this.connections.add(connection);
    }

    protected void clearTimeout(Connection connection) {
        long currentTimeout = this.getConnectionTimeout(connection);
        if (currentTimeout > 0L) {
            this.setConnectionTimeout(connection, 0L);
        }
    }

    protected void resetTimeout(Connection connection) {
        long currentTimeout = this.getConnectionTimeout(connection);
        if (currentTimeout >= 0L) {
            this.setExpirationTime(connection, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    protected long getConnectionTimeout(Connection connection) {
        return idleAttribute.get(connection);
    }

    protected void setConnectionTimeout(Connection connection, long timeout) {
        idleAttribute.set(connection, (Long)timeout);
    }

    public Long getExpirationTime(Connection connection, TimeUnit timeunit) {
        long expirationTime = this.getConnectionTimeout(connection);
        if (expirationTime > 0L && timeunit != TimeUnit.MILLISECONDS) {
            return timeunit.convert(expirationTime, TimeUnit.MILLISECONDS);
        }
        return expirationTime;
    }

    public void setExpirationTime(Connection connection, long timeout, TimeUnit timeunit) {
        if (timeout > 0L && timeunit != TimeUnit.MILLISECONDS) {
            this.setConnectionTimeout(connection, TimeUnit.MILLISECONDS.convert(timeout, timeunit));
        } else {
            this.setConnectionTimeout(connection, timeout);
        }
    }

    public class TimeoutChecker
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTimeMillis = System.currentTimeMillis();
            long nextTimeout = IdleTimeoutFilter.this.timeoutMillis;
            try {
                Iterator it = IdleTimeoutFilter.this.connections.iterator();
                while (it.hasNext()) {
                    Connection connection = (Connection)it.next();
                    if (!connection.isOpen()) {
                        it.remove();
                        continue;
                    }
                    Long expirationTime = IdleTimeoutFilter.this.getExpirationTime(connection, TimeUnit.MILLISECONDS);
                    if (expirationTime == 0L) continue;
                    long diff = currentTimeMillis - expirationTime;
                    if (diff >= 0L) {
                        try {
                            connection.close();
                            continue;
                        }
                        catch (IOException e) {
                            Grizzly.logger.log(Level.FINE, "IdleTimeoutFilter:unexpected exception, when trying to close connection", e);
                            continue;
                        }
                        finally {
                            it.remove();
                            continue;
                        }
                    }
                    if (nextTimeout <= (diff = -diff)) continue;
                    nextTimeout = diff;
                }
            }
            catch (Exception e) {
                Grizzly.logger.log(Level.WARNING, "IdleTimeoutFilter: unexpected exception", e);
            }
            finally {
                if (this == IdleTimeoutFilter.this.checker) {
                    IdleTimeoutFilter.this.scheduledFuture = IdleTimeoutFilter.this.scheduledThreadPool.schedule(IdleTimeoutFilter.this.checker, nextTimeout, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

