/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.util;

import java.io.IOException;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.streams.AddressableStreamReader;
import org.glassfish.grizzly.streams.AddressableStreamWriter;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;

public class EchoFilter
extends FilterAdapter {
    private static final Logger logger = Grizzly.logger;

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Object message = ctx.getMessage();
        if (message != null) {
            Connection connection = ctx.getConnection();
            Transformer encoder = ctx.getFilterChain().getCodec().getEncoder();
            TransformationResult<Object> result = encoder.transform(connection, message, null);
            encoder.release(connection);
            Buffer buffer = result.getMessage();
            Object address = ctx.getAddress();
            connection.write(address, buffer);
        } else {
            StreamReader reader = ctx.getStreamReader();
            StreamWriter writer = ctx.getStreamWriter();
            if (writer instanceof AddressableStreamWriter) {
                AddressableStreamReader addressableReader = (AddressableStreamReader)reader;
                addressableReader.getBuffer();
                Object peerAddress = addressableReader.getPeerAddress();
                AddressableStreamWriter addressableWriter = (AddressableStreamWriter)writer;
                if (addressableWriter.getPeerAddress() == null) {
                    addressableWriter.setPeerAddress(peerAddress);
                }
            }
            writer.writeStream(reader);
            writer.flush();
        }
        return nextAction;
    }
}

