/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.util;

import org.glassfish.grizzly.util.LinkedTransferQueue;
import org.glassfish.grizzly.util.ObjectPool;
import org.glassfish.grizzly.util.PoolableObject;

public abstract class ConcurrentQueuePool<E extends PoolableObject>
implements ObjectPool<E> {
    private final LinkedTransferQueue<E> pool = new LinkedTransferQueue();

    public abstract E newInstance();

    @Override
    public E poll() {
        PoolableObject object = (PoolableObject)this.pool.poll();
        if (object == null) {
            object = this.newInstance();
        }
        object.prepare();
        return (E)object;
    }

    @Override
    public void offer(E object) {
        object.release();
        this.pool.offer(object);
    }

    @Override
    public void clear() {
        this.pool.clear();
    }
}

