/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ProcessorRunnable;
import org.glassfish.grizzly.Strategy;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.strategies.LeaderFollowerStrategy;
import org.glassfish.grizzly.strategies.SameThreadStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadStrategy;
import org.glassfish.grizzly.util.CurrentThreadExecutor;
import org.glassfish.grizzly.util.WorkerThreadExecutor;

public class SimpleDynamicStrategy
implements Strategy<DynamicStrategyContext> {
    private SameThreadStrategy sameThreadStrategy = new SameThreadStrategy();
    private LeaderFollowerStrategy leaderFollowerStrategy;
    private WorkerThreadStrategy workerThreadStrategy;
    private int leaderFollowerThreshold = 1;
    private int workerThreadThreshold = 32;

    public SimpleDynamicStrategy(NIOTransport transport) {
        this(new CurrentThreadExecutor(), new WorkerThreadExecutor(transport));
    }

    public SimpleDynamicStrategy(Executor sameThreadProcessorExecutor, Executor workerThreadProcessorExecutor) {
        this.leaderFollowerStrategy = new LeaderFollowerStrategy(sameThreadProcessorExecutor, workerThreadProcessorExecutor);
        this.workerThreadStrategy = new WorkerThreadStrategy(sameThreadProcessorExecutor, workerThreadProcessorExecutor);
    }

    @Override
    public DynamicStrategyContext prepare(Connection connection, IOEvent ioEvent) {
        return new DynamicStrategyContext(((NIOConnection)connection).getSelectorRunner().getLastSelectedKeysCount());
    }

    @Override
    public void executeProcessor(DynamicStrategyContext strategyContext, ProcessorRunnable processorRunnable) throws IOException {
        if (strategyContext == null) {
            this.workerThreadStrategy.executeProcessor(strategyContext, processorRunnable);
            return;
        }
        int lastSelectedKeysCount = strategyContext.lastSelectedKeysCount;
        if (lastSelectedKeysCount >= this.workerThreadThreshold) {
            this.workerThreadStrategy.executeProcessor(strategyContext, processorRunnable);
        } else if (lastSelectedKeysCount >= this.leaderFollowerThreshold) {
            strategyContext.isTerminateThread = true;
            this.leaderFollowerStrategy.executeProcessor(strategyContext.isTerminateThread, processorRunnable);
        } else {
            this.sameThreadStrategy.executeProcessor(strategyContext, processorRunnable);
        }
    }

    @Override
    public boolean isTerminateThread(DynamicStrategyContext strategyContext) {
        return strategyContext.isTerminateThread;
    }

    public int getLeaderFollowerThreshold() {
        return this.leaderFollowerThreshold;
    }

    public void setLeaderFollowerThreshold(int leaderFollowerThreshold) {
        this.leaderFollowerThreshold = leaderFollowerThreshold;
        this.checkThresholds();
    }

    public int getWorkerThreadThreshold() {
        return this.workerThreadThreshold;
    }

    public void setWorkerThreadThreshold(int workerThreadThreshold) {
        this.workerThreadThreshold = workerThreadThreshold;
        this.checkThresholds();
    }

    private void checkThresholds() {
        if (this.leaderFollowerThreshold >= 0 && this.workerThreadThreshold >= this.leaderFollowerThreshold) {
            return;
        }
        throw new IllegalStateException("Thresholds settings are incorrect");
    }

    public static final class DynamicStrategyContext {
        final int lastSelectedKeysCount;
        boolean isTerminateThread;

        public DynamicStrategyContext(int lastSelectedKeysCount) {
            this.lastSelectedKeysCount = lastSelectedKeysCount;
        }
    }
}

