/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ProcessorRunnable;
import org.glassfish.grizzly.Strategy;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.util.CurrentThreadExecutor;
import org.glassfish.grizzly.util.WorkerThreadExecutor;

public class LeaderFollowerStrategy
implements Strategy<Boolean> {
    private Executor sameThreadProcessorExecutor;
    private Executor workerThreadProcessorExecutor;

    public LeaderFollowerStrategy(NIOTransport transport) {
        this(new CurrentThreadExecutor(), new WorkerThreadExecutor(transport));
    }

    public LeaderFollowerStrategy(Executor sameThreadProcessorExecutor, Executor workerThreadProcessorExecutor) {
        this.sameThreadProcessorExecutor = sameThreadProcessorExecutor;
        this.workerThreadProcessorExecutor = workerThreadProcessorExecutor;
    }

    @Override
    public Boolean prepare(Connection connection, IOEvent ioEvent) {
        return true;
    }

    @Override
    public void executeProcessor(Boolean strategyContext, ProcessorRunnable processorRunnable) throws IOException {
        if (strategyContext != null && strategyContext.booleanValue()) {
            NIOConnection nioConnection = (NIOConnection)processorRunnable.getConnection();
            SelectorRunner runner = nioConnection.getSelectorRunner();
            runner.postpone();
            nioConnection.getTransport().getWorkerThreadPool().execute(runner);
        }
        Executor executor = this.getProcessorExecutor(strategyContext);
        executor.execute(processorRunnable);
    }

    @Override
    public boolean isTerminateThread(Boolean strategyContext) {
        return strategyContext;
    }

    public Executor getProcessorExecutor(Boolean strategyContext) {
        if (strategyContext != null && strategyContext.booleanValue()) {
            return this.sameThreadProcessorExecutor;
        }
        return this.workerThreadProcessorExecutor;
    }
}

