/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLHandshaker;
import org.glassfish.grizzly.ssl.SSLResourcesAccessor;
import org.glassfish.grizzly.ssl.SSLStreamReader;
import org.glassfish.grizzly.ssl.SSLStreamWriter;
import org.glassfish.grizzly.ssl.SSLSupport;

public class SSLSupportImpl
implements SSLSupport {
    private static Logger logger = Grizzly.logger;
    public static final String KEY_SIZE_KEY = "SSL_KEY_SIZE";
    private SSLEngine engine;
    private SSLSession session;
    private SSLEngineConfigurator engineConfigurator;
    private SSLHandshaker handshaker;
    private SSLStreamReader reader;
    private SSLStreamWriter writer;

    public SSLSupportImpl(SSLEngineConfigurator engineConfigurator, SSLHandshaker handshaker, SSLStreamReader reader, SSLStreamWriter writer) {
        this.engineConfigurator = engineConfigurator;
        this.handshaker = handshaker;
        this.reader = reader;
        this.writer = writer;
        this.engine = SSLResourcesAccessor.getInstance().getSSLEngine(reader.getConnection());
        this.session = this.engine.getSession();
    }

    @Override
    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    @Override
    public Object[] getPeerCertificateChain() throws IOException {
        return this.getPeerCertificateChain(false);
    }

    protected java.security.cert.X509Certificate[] getX509Certificates(SSLSession session) throws IOException {
        X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new X509Certificate[]{};
        }
        java.security.cert.X509Certificate[] x509Certs = new java.security.cert.X509Certificate[jsseCerts.length];
        for (int i = 0; i < x509Certs.length; ++i) {
            try {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Cert #" + i + " = " + x509Certs[i]);
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Error translating " + jsseCerts[i], ex);
                return null;
            }
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    @Override
    public Object[] getPeerCertificateChain(boolean force) throws IOException {
        if (this.session == null) {
            return null;
        }
        X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = this.session.getPeerCertificateChain();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jsseCerts == null) {
            jsseCerts = new X509Certificate[]{};
        }
        if (jsseCerts.length <= 0 && force) {
            this.session.invalidate();
            this.handshaker.handshake(this.reader, this.writer, this.engineConfigurator);
            this.session = this.engine.getSession();
        }
        return this.getX509Certificates(this.session);
    }

    @Override
    public Integer getKeySize() throws IOException {
        SSLSupport.CipherData[] c_aux = ciphers;
        if (this.session == null) {
            return null;
        }
        Integer keySize = (Integer)this.session.getValue(KEY_SIZE_KEY);
        if (keySize == null) {
            int size = 0;
            String cipherSuite = this.session.getCipherSuite();
            for (int i = 0; i < c_aux.length; ++i) {
                if (cipherSuite.indexOf(c_aux[i].phrase) < 0) continue;
                size = c_aux[i].keySize;
                break;
            }
            keySize = size;
            this.session.putValue(KEY_SIZE_KEY, keySize);
        }
        return keySize;
    }

    @Override
    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] ssl_session = this.session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("");
        for (int x = 0; x < ssl_session.length; ++x) {
            String digit = Integer.toHexString(ssl_session[x]);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }
}

