/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.ssl.SSLResourcesAccessor;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.streams.StreamWriter;
import org.glassfish.grizzly.streams.StreamWriterDecorator;

public class SSLStreamWriter
extends StreamWriterDecorator {
    public SSLStreamWriter() {
        this((StreamWriter)null);
    }

    public SSLStreamWriter(StreamWriter underlyingWriter) {
        super(underlyingWriter);
        this.setUnderlyingWriter(underlyingWriter);
    }

    @Override
    public void setUnderlyingWriter(StreamWriter underlyingWriter) {
        super.setUnderlyingWriter(underlyingWriter);
        try {
            this.checkBuffers();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public SSLEngine getSSLEngine() {
        SSLResourcesAccessor resourceAccessor = SSLResourcesAccessor.getInstance();
        return resourceAccessor.getSSLEngine(this.getConnection());
    }

    Future<Integer> handshakeWrap(CompletionHandler completionHandler) throws IOException {
        this.overflow();
        return this.flush0((Buffer)this.getConnection().getTransport().getMemoryManager().allocate(0), completionHandler);
    }

    private void checkBuffers() throws IOException {
        SSLEngine sslEngine = this.getSSLEngine();
        if (sslEngine != null) {
            int appBufferSize;
            if (this.underlyingWriter != null) {
                Buffer underlyingBuffer;
                int underlyingBufferSize = sslEngine.getSession().getPacketBufferSize();
                if (this.underlyingWriter.getBufferSize() < underlyingBufferSize) {
                    this.underlyingWriter.setBufferSize(underlyingBufferSize);
                }
                if ((underlyingBuffer = this.underlyingWriter.getBuffer()) == null || underlyingBuffer.remaining() < underlyingBufferSize) {
                    this.underlyingWriter.flush();
                }
            }
            if (this.bufferSize < (appBufferSize = sslEngine.getSession().getApplicationBufferSize())) {
                this.bufferSize = appBufferSize;
            }
        }
    }

    @Override
    protected Future<Integer> flush0(Buffer buffer, CompletionHandler<Integer> completionHandler) throws IOException {
        Future<Integer> lastWriterFuture = null;
        SSLEngine sslEngine = this.getSSLEngine();
        this.checkBuffers();
        if (buffer != null) {
            buffer.flip();
            if (buffer.remaining() > 0 && SSLUtils.isHandshaking(sslEngine)) {
                throw new IllegalStateException("Handshake was not completed");
            }
            ByteBuffer byteBuffer = (ByteBuffer)buffer.underlying();
            do {
                Buffer underlyingBuffer = this.underlyingWriter.getBuffer();
                ByteBuffer underlyingByteBuffer = (ByteBuffer)underlyingBuffer.underlying();
                sslEngine.wrap(byteBuffer, underlyingByteBuffer);
                lastWriterFuture = this.underlyingWriter.flush();
            } while (buffer.hasRemaining());
            buffer.clear();
        } else if (this.buffer == null) {
            this.buffer = this.newBuffer(this.bufferSize);
        }
        return lastWriterFuture;
    }
}

