/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.Future;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.ssl.SSLResourcesAccessor;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamReaderDecorator;
import org.glassfish.grizzly.util.conditions.Condition;

public class SSLStreamReader
extends StreamReaderDecorator {
    public static Attribute<LinkedList> sslAttribute = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SSL_REMAINDER");

    public SSLStreamReader() {
        this((StreamReader)null);
    }

    public SSLStreamReader(StreamReader underlyingReader) {
        super(underlyingReader);
    }

    @Override
    public void setUnderlyingReader(StreamReader underlyingReader) {
        super.setUnderlyingReader(underlyingReader);
        if (underlyingReader != null) {
            this.checkBuffers();
            this.attach();
        }
    }

    @Override
    public boolean appendBuffer(Buffer buffer) {
        if (buffer == null) {
            return false;
        }
        this.checkBuffers();
        boolean wasAdded = true;
        SSLEngine sslEngine = this.getSSLEngine();
        while (wasAdded && buffer.hasRemaining()) {
            SSLEngineResult result;
            ByteBuffer underlyingByteBuffer = (ByteBuffer)buffer.underlying();
            Buffer newBuffer = this.newBuffer(this.bufferSize);
            ByteBuffer appByteBuffer = (ByteBuffer)newBuffer.underlying();
            try {
                result = sslEngine.unwrap(underlyingByteBuffer, appByteBuffer);
            }
            catch (SSLException e) {
                newBuffer.dispose();
                throw new IllegalStateException(e);
            }
            if (result.getStatus() == SSLEngineResult.Status.OK || result.getStatus() == SSLEngineResult.Status.CLOSED) {
                if (result.bytesProduced() > 0 || result.bytesConsumed() > 0) {
                    newBuffer.trim();
                    wasAdded = super.appendBuffer(newBuffer);
                    continue;
                }
                wasAdded = false;
                newBuffer.dispose();
                continue;
            }
            newBuffer.dispose();
            wasAdded = false;
        }
        if (wasAdded) {
            buffer.dispose();
        }
        return wasAdded;
    }

    public SSLEngine getSSLEngine() {
        SSLResourcesAccessor resourceAccessor = SSLResourcesAccessor.getInstance();
        return resourceAccessor.getSSLEngine(this.getConnection());
    }

    protected void attach() {
        Connection connection = this.getConnection();
        if (connection == null || connection.getAttributes() == null) {
            return;
        }
        LinkedList attachedBuffers = sslAttribute.remove(connection.getAttributes());
        if (attachedBuffers != null) {
            this.dataRecords = attachedBuffers;
        } else if (this.dataRecords == null) {
            this.dataRecords = new LinkedList();
        }
    }

    protected void detach() {
        if (this.dataRecords != null && !this.dataRecords.isEmpty()) {
            sslAttribute.set(this.getConnection().obtainAttributes(), this.dataRecords);
            this.dataRecords = null;
        }
    }

    Future handshakeUnwrap(CompletionHandler completionHandler) throws IOException {
        return this.notifyCondition(new Condition<StreamReader>(){

            @Override
            public boolean check(StreamReader state) {
                return SSLStreamReader.this.getSSLEngine().getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }, completionHandler);
    }

    @Override
    protected Buffer read0() throws IOException {
        return this.underlyingReader.readBuffer();
    }

    private void checkBuffers() {
        SSLEngine sslEngine = this.getSSLEngine();
        if (sslEngine != null) {
            int appBufferSize;
            int underlyingBufferSize = sslEngine.getSession().getPacketBufferSize();
            if (this.underlyingReader.getBufferSize() < underlyingBufferSize) {
                this.underlyingReader.setBufferSize(underlyingBufferSize);
            }
            if (this.bufferSize < (appBufferSize = sslEngine.getSession().getApplicationBufferSize())) {
                this.bufferSize = appBufferSize;
            }
        }
    }

    @Override
    protected final Object wrap(Buffer buffer) {
        return buffer;
    }

    @Override
    protected Buffer unwrap(Object data) {
        return (Buffer)data;
    }
}

