/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.filterchain.CodecFilter;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.StreamTransformerFilter;
import org.glassfish.grizzly.ssl.BlockingSSLHandshaker;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLDecoderTransformer;
import org.glassfish.grizzly.ssl.SSLEncoderTransformer;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLHandshaker;
import org.glassfish.grizzly.ssl.SSLResourcesAccessor;
import org.glassfish.grizzly.ssl.SSLStreamReader;
import org.glassfish.grizzly.ssl.SSLStreamWriter;
import org.glassfish.grizzly.ssl.SSLSupport;
import org.glassfish.grizzly.ssl.SSLSupportImpl;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;

public class SSLFilter
extends FilterAdapter
implements CodecFilter,
StreamTransformerFilter {
    private Logger logger = Grizzly.logger;
    private final SSLEngineConfigurator sslEngineConfigurator;
    private final SSLHandshaker sslHandshaker;
    private final SSLDecoderTransformer decoder;
    private final SSLEncoderTransformer encoder;

    public SSLFilter() {
        this(null);
    }

    public SSLFilter(SSLEngineConfigurator sslEngineConfigurator) {
        this(sslEngineConfigurator, null);
    }

    public SSLFilter(SSLEngineConfigurator sslEngineConfigurator, SSLHandshaker sslHandshaker) {
        if (sslEngineConfigurator == null) {
            sslEngineConfigurator = new SSLEngineConfigurator(SSLContextConfigurator.DEFAULT_CONFIG.createSSLContext(), false, false, false);
        }
        this.sslEngineConfigurator = sslEngineConfigurator;
        if (sslHandshaker == null) {
            sslHandshaker = new BlockingSSLHandshaker();
        }
        this.sslHandshaker = sslHandshaker;
        this.decoder = new SSLDecoderTransformer();
        this.encoder = new SSLEncoderTransformer();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Future<SSLEngine> future;
        Connection connection = ctx.getConnection();
        SSLResourcesAccessor sslResourceAccessor = SSLResourcesAccessor.getInstance();
        SSLEngine sslEngine = sslResourceAccessor.getSSLEngine(connection);
        if (sslEngine == null) {
            sslEngine = this.sslEngineConfigurator.createSSLEngine();
            sslResourceAccessor.setSSLEngine(connection, sslEngine);
        }
        StreamReader parentReader = ctx.getStreamReader();
        StreamWriter parentWriter = ctx.getStreamWriter();
        SSLStreamReader sslStreamReader = new SSLStreamReader(parentReader);
        SSLStreamWriter sslStreamWriter = new SSLStreamWriter(parentWriter);
        ctx.setStreamReader(sslStreamReader);
        ctx.setStreamWriter(sslStreamWriter);
        sslStreamReader.pull();
        if (SSLUtils.isHandshaking(sslEngine) && !(future = this.sslHandshaker.handshake(sslStreamReader, sslStreamWriter, this.sslEngineConfigurator)).isDone()) {
            return ctx.getStopAction();
        }
        if (sslStreamReader.availableDataSize() <= 0) {
            nextAction = ctx.getStopAction();
        }
        return nextAction;
    }

    @Override
    public NextAction postRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        SSLStreamReader sslStreamReader = (SSLStreamReader)ctx.getStreamReader();
        SSLStreamWriter sslStreamWriter = (SSLStreamWriter)ctx.getStreamWriter();
        sslStreamReader.detach();
        ctx.setStreamReader(sslStreamReader.getUnderlyingReader());
        ctx.setStreamWriter(sslStreamWriter.getUnderlyingWriter());
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        StreamWriter writer = ctx.getStreamWriter();
        Object message = ctx.getMessage();
        if (message instanceof Buffer) {
            writer.writeBuffer((Buffer)message);
        }
        writer.flush();
        return nextAction;
    }

    @Override
    public NextAction postWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        return nextAction;
    }

    @Override
    public NextAction postClose(FilterChainContext ctx, NextAction nextAction) throws IOException {
        SSLResourcesAccessor.getInstance().clear(ctx.getConnection());
        return nextAction;
    }

    @Override
    public StreamReader getStreamReader(StreamReader parentStreamReader) {
        return new SSLStreamReader(parentStreamReader);
    }

    @Override
    public StreamWriter getStreamWriter(StreamWriter parentStreamWriter) {
        return new SSLStreamWriter(parentStreamWriter);
    }

    public SSLSupport createSSLSupport(SSLStreamReader reader, SSLStreamWriter writer) {
        return new SSLSupportImpl(this.sslEngineConfigurator, this.sslHandshaker, reader, writer);
    }

    @Override
    public Transformer getDecoder() {
        return this.decoder;
    }

    @Override
    public Transformer getEncoder() {
        return this.encoder;
    }
}

