/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLEngineConfigurator {
    private SSLContext sslContext;
    private String[] enabledCipherSuites = null;
    private String[] enabledProtocols = null;
    private boolean clientMode;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private boolean isProtocolConfigured = false;
    private boolean isCipherConfigured = false;

    public SSLEngineConfigurator(SSLContext sslContext) {
        this(sslContext, true, false, false);
    }

    public SSLEngineConfigurator(SSLContext sslContext, boolean clientMode, boolean needClientAuth, boolean wantClientAuth) {
        this.sslContext = sslContext;
        this.clientMode = clientMode;
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = wantClientAuth;
    }

    public SSLEngine createSSLEngine() {
        SSLEngine sslEngine = this.sslContext.createSSLEngine();
        this.configure(sslEngine);
        return sslEngine;
    }

    public void configure(SSLEngine sslEngine) {
        if (this.enabledCipherSuites != null) {
            if (!this.isCipherConfigured) {
                this.enabledCipherSuites = SSLEngineConfigurator.configureEnabledCiphers(sslEngine, this.enabledCipherSuites);
                this.isCipherConfigured = true;
            }
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            if (!this.isProtocolConfigured) {
                this.enabledProtocols = SSLEngineConfigurator.configureEnabledProtocols(sslEngine, this.enabledProtocols);
                this.isProtocolConfigured = true;
            }
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        sslEngine.setWantClientAuth(this.wantClientAuth);
        sslEngine.setNeedClientAuth(this.needClientAuth);
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public boolean isCipherConfigured() {
        return this.isCipherConfigured;
    }

    public void setCipherConfigured(boolean isCipherConfigured) {
        this.isCipherConfigured = isCipherConfigured;
    }

    public boolean isProtocolConfigured() {
        return this.isProtocolConfigured;
    }

    public void setProtocolConfigured(boolean isProtocolConfigured) {
        this.isProtocolConfigured = isProtocolConfigured;
    }

    private static final String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static final String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SSLEngineConfigurator[clientMode=");
        sb.append(this.clientMode);
        sb.append(", needClientAuth=").append(this.needClientAuth);
        sb.append(", wantClientAuth=").append(this.wantClientAuth);
        sb.append(", enabledProtocols=").append(this.enabledProtocols);
        sb.append(", enabledCipherSuites=").append(this.enabledCipherSuites);
        sb.append(']');
        return sb.toString();
    }
}

