/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLHandshaker;
import org.glassfish.grizzly.ssl.SSLResourcesAccessor;
import org.glassfish.grizzly.ssl.SSLStreamReader;
import org.glassfish.grizzly.ssl.SSLStreamWriter;
import org.glassfish.grizzly.ssl.SSLUtils;

public class BlockingSSLHandshaker
implements SSLHandshaker {
    private Logger logger = Grizzly.logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<SSLEngine> handshake(SSLStreamReader reader, SSLStreamWriter writer, SSLEngineConfigurator configurator) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus;
        boolean isLoggingFinest;
        Connection connection = reader.getConnection();
        SSLResourcesAccessor resourceAccessor = SSLResourcesAccessor.getInstance();
        SSLEngine sslEngine = resourceAccessor.getSSLEngine(connection);
        if (sslEngine == null) {
            sslEngine = configurator.createSSLEngine();
            resourceAccessor.setSSLEngine(connection, sslEngine);
        }
        if (isLoggingFinest = this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("connection=" + connection + " engine=" + sslEngine + " handshakeStatus=" + (Object)((Object)sslEngine.getHandshakeStatus()));
        }
        if ((handshakeStatus = sslEngine.getHandshakeStatus()) == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            sslEngine.beginHandshake();
            handshakeStatus = sslEngine.getHandshakeStatus();
        }
        boolean readerMode = reader.isBlocking();
        boolean writerMode = writer.isBlocking();
        try {
            reader.setBlocking(true);
            writer.setBlocking(true);
            block10: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                if (isLoggingFinest) {
                    this.logger.finest("Loop Engine: " + sslEngine + " handshakeStatus=" + (Object)((Object)sslEngine.getHandshakeStatus()));
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        if (isLoggingFinest) {
                            this.logger.finest("NEED_UNWRAP Engine: " + sslEngine);
                        }
                        Future<Integer> future = reader.handshakeUnwrap(null);
                        future.get(10L, TimeUnit.SECONDS);
                        handshakeStatus = sslEngine.getHandshakeStatus();
                        continue block10;
                    }
                    case NEED_WRAP: {
                        if (isLoggingFinest) {
                            this.logger.finest("NEED_WRAP Engine: " + sslEngine);
                        }
                        Future<Integer> future = writer.handshakeWrap(null);
                        future.get(10L, TimeUnit.SECONDS);
                        handshakeStatus = sslEngine.getHandshakeStatus();
                        continue block10;
                    }
                    case NEED_TASK: {
                        if (isLoggingFinest) {
                            this.logger.finest("NEED_TASK Engine: " + sslEngine);
                        }
                        SSLUtils.executeDelegatedTask(sslEngine);
                        handshakeStatus = sslEngine.getHandshakeStatus();
                        continue block10;
                    }
                }
                throw new RuntimeException("Invalid Handshaking State" + (Object)((Object)handshakeStatus));
            }
        }
        catch (Exception e) {
            ReadyFutureImpl<SSLEngine> readyFutureImpl = new ReadyFutureImpl<SSLEngine>(e);
            return readyFutureImpl;
        }
        finally {
            reader.setBlocking(readerMode);
            writer.setBlocking(writerMode);
        }
        return new ReadyFutureImpl<SSLEngine>(sslEngine);
    }
}

