/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.smart.transformers;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.smart.SmartTransformer;
import org.glassfish.grizzly.smart.annotations.CharSequence;
import org.glassfish.grizzly.smart.transformers.SmartMemberTransformer;
import org.glassfish.grizzly.util.StringDecoder;

public class SmartStringDecoder
extends StringDecoder
implements SmartMemberTransformer<Buffer, String> {
    protected Attribute<List> messageProcessingTreeAttribute;

    public SmartStringDecoder() {
        this((String)null);
    }

    public SmartStringDecoder(String stringTerminator) {
        this(Charset.forName("UTF-8"), stringTerminator);
    }

    public SmartStringDecoder(Charset charset) {
        this(charset, null);
    }

    public SmartStringDecoder(Charset charset, String stringTerminator) {
        super(charset, stringTerminator);
        this.messageProcessingTreeAttribute = this.attributeBuilder.createAttribute("SmartDecoderTransformer.processingTree");
    }

    @Override
    public void initialize(SmartTransformer parentTransformer, Field field) {
        CharSequence charSequenceAnn = field.getAnnotation(CharSequence.class);
        if (charSequenceAnn != null) {
            String terminateSeqAnn;
            String charsetAnn = charSequenceAnn.charset();
            if (!charsetAnn.equals(this.charset.name())) {
                this.charset = Charset.forName(charsetAnn);
            }
            if ((terminateSeqAnn = charSequenceAnn.terminate()) != null && terminateSeqAnn.length() > 0) {
                try {
                    this.stringTerminateBytes = terminateSeqAnn.getBytes(this.charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public List getMessageProcessingTree(AttributeStorage storage) {
        return SmartStringDecoder.getValue(storage, this.messageProcessingTreeAttribute);
    }

    @Override
    public Object getCurrentMessageProcessingObject(AttributeStorage storage) {
        List messageProcessingTree = this.getMessageProcessingTree(storage);
        return messageProcessingTree.get(messageProcessingTree.size() - 1);
    }
}

