/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.smart.transformers;

import java.lang.reflect.Field;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.smart.Reference;
import org.glassfish.grizzly.smart.SmartTransformer;
import org.glassfish.grizzly.smart.Value;
import org.glassfish.grizzly.smart.annotations.Sequence;
import org.glassfish.grizzly.smart.transformers.AbstractSmartMemberDecoder;

public abstract class SequenceDecoder<E>
extends AbstractSmartMemberDecoder<E> {
    protected Sequence config;
    protected Class componentType;
    protected Transformer componentDecoder;
    protected Attribute<E> sequenceAttribute;
    private Value<Number> size;
    private Value<Number> limit;

    protected abstract E createSequence(AttributeStorage var1, int var2);

    protected abstract void set(AttributeStorage var1, E var2, Object var3);

    protected abstract boolean next(AttributeStorage var1, E var2);

    protected abstract int size(AttributeStorage var1, E var2);

    public SequenceDecoder() {
        String prefix = this.getClass().getName();
        this.sequenceAttribute = this.attributeBuilder.createAttribute(prefix + ".sequence");
    }

    @Override
    public void initialize(SmartTransformer parentTransformer, Field field) {
        Transformer componentTransformer;
        super.initialize(parentTransformer, field);
        this.setComponentType(field.getType().getComponentType());
        Class<?> prefTransformerClass = null;
        Sequence sequence = field.getAnnotation(Sequence.class);
        if (sequence != null) {
            String prefTransformerClassName;
            if (sequence.codec() != null && sequence.codec().decoder() != null && (prefTransformerClassName = sequence.codec().decoder()) != null && prefTransformerClassName.length() > 0) {
                try {
                    prefTransformerClass = Class.forName(prefTransformerClassName);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        } else {
            throw new IllegalStateException("Sequence annotation should be used with array element!");
        }
        if ((componentTransformer = parentTransformer.createTransformer(this.componentType, prefTransformerClass)) == null) {
            throw new IllegalStateException("Can not find decoder for type: " + this.componentType);
        }
        this.setConfig(sequence);
        this.setComponentDecoder(componentTransformer);
    }

    @Override
    public TransformationResult<E> transform(AttributeStorage storage, Buffer input, E output) throws TransformationException {
        if (input == null) {
            throw new TransformationException("Input should not be null");
        }
        E sequence = this.getSequence(storage);
        if (sequence == null) {
            int annotatedSize = this.checkSize(storage);
            sequence = this.createSequence(storage, annotatedSize);
        }
        while (this.next(storage, sequence)) {
            TransformationResult<Object> result = this.componentDecoder.transform(storage, input, null);
            TransformationResult.Status status = result.getStatus();
            if (status == TransformationResult.Status.COMPLETED) {
                this.componentDecoder.release(storage);
                this.set(storage, sequence, result.getMessage());
                continue;
            }
            if (status == TransformationResult.Status.INCOMPLED) {
                this.saveState(storage, sequence, incompletedResult);
                return incompletedResult;
            }
            return result;
        }
        TransformationResult<E> result = new TransformationResult<E>(TransformationResult.Status.COMPLETED, sequence);
        this.saveState(storage, sequence, result);
        return result;
    }

    @Override
    public void release(AttributeStorage storage) {
        SequenceDecoder.removeValue(storage, this.sequenceAttribute);
        super.release(storage);
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public void setComponentType(Class componentClass) {
        this.componentType = componentClass;
    }

    public Transformer getComponentDecoder() {
        return this.componentDecoder;
    }

    public void setComponentDecoder(Transformer elementDecoder) {
        this.componentDecoder = elementDecoder;
    }

    public Sequence getConfig() {
        return this.config;
    }

    public void setConfig(Sequence config) {
        this.config = config;
    }

    protected void saveState(AttributeStorage storage, E sequence, TransformationResult<E> lastResult) {
        SequenceDecoder.setValue(storage, this.sequenceAttribute, sequence);
        SequenceDecoder.setValue(storage, this.lastResultAttribute, lastResult);
    }

    protected E getSequence(AttributeStorage storage) {
        return SequenceDecoder.getValue(storage, this.sequenceAttribute);
    }

    protected int checkSize(AttributeStorage storage) {
        int annotatedSize = this.getAnnotatedSize(storage);
        if (annotatedSize >= 0) {
            int annotatedLimit = this.getAnnotatedLimit(storage);
            if (annotatedLimit > -1 && annotatedSize > annotatedLimit) {
                throw new TransformationException("Size " + annotatedSize + " is bigger than limit " + annotatedLimit);
            }
        } else {
            throw new TransformationException("The array size is not defined");
        }
        return annotatedSize;
    }

    protected int getAnnotatedSize(AttributeStorage storage) {
        Integer directValue;
        Object message = null;
        if (this.size == null) {
            String configSize = this.config.size();
            if (configSize == null) {
                return -1;
            }
            try {
                int value = Integer.parseInt(configSize);
                this.size = new Value<Integer>(value);
            }
            catch (NumberFormatException e) {
                message = this.getCurrentMessageProcessingObject(storage);
                this.size = new Value(new Reference(message.getClass(), configSize));
            }
        }
        if ((directValue = (Integer)this.size.get()) != null) {
            return directValue;
        }
        try {
            if (message == null) {
                message = this.getCurrentMessageProcessingObject(storage);
            }
            return this.size.getByReference(message).intValue();
        }
        catch (Exception e) {
            return -1;
        }
    }

    protected int getAnnotatedLimit(AttributeStorage storage) {
        Integer directValue;
        Object message = null;
        if (this.limit == null) {
            String configLimit = this.config.limit();
            if (configLimit == null) {
                return -1;
            }
            try {
                int value = Integer.parseInt(configLimit);
                this.limit = new Value<Integer>(value);
            }
            catch (NumberFormatException e) {
                message = this.getCurrentMessageProcessingObject(storage);
                this.limit = new Value(new Reference(message.getClass(), configLimit));
            }
        }
        if ((directValue = (Integer)this.limit.get()) != null) {
            return directValue;
        }
        try {
            if (message == null) {
                message = this.getCurrentMessageProcessingObject(storage);
            }
            return this.limit.getByReference(message).intValue();
        }
        catch (Exception e) {
            return -1;
        }
    }
}

