/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.smart;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.smart.SequenceUnit;
import org.glassfish.grizzly.smart.SmartTransformer;
import org.glassfish.grizzly.smart.annotations.Codec;
import org.glassfish.grizzly.smart.transformers.ArrayEncoder;
import org.glassfish.grizzly.smart.transformers.ByteEncoder;
import org.glassfish.grizzly.smart.transformers.CharEncoder;
import org.glassfish.grizzly.smart.transformers.DoubleEncoder;
import org.glassfish.grizzly.smart.transformers.FloatEncoder;
import org.glassfish.grizzly.smart.transformers.IntegerEncoder;
import org.glassfish.grizzly.smart.transformers.LongEncoder;
import org.glassfish.grizzly.smart.transformers.ShortEncoder;
import org.glassfish.grizzly.smart.transformers.SmartMemberTransformer;
import org.glassfish.grizzly.smart.transformers.SmartStringEncoder;

public class SmartEncoderTransformer<E>
extends AbstractTransformer<E, Buffer>
implements SmartTransformer<E, Buffer> {
    public static final String MESSAGE_PROCESSING_TREE_ATTR_NAME = "SmartEncoderTransformer.processingTree";
    private Map<Class, Class<? extends Transformer>> predefinedTransformers;
    private Class<E> messageClass;
    private List<SequenceUnit> encodingSequence;
    protected Attribute<List> messageProcessingTreeAttribute;
    protected Attribute<Integer> currentTransformerIdxAttribute;

    public SmartEncoderTransformer(Class<E> messageClass) {
        this.messageClass = messageClass;
        this.initializePredefinedTransformers();
        this.encodingSequence = new ArrayList<SequenceUnit>();
        this.createTransformerSequence(messageClass, this.encodingSequence);
        this.currentTransformerIdxAttribute = this.attributeBuilder.createAttribute("SmartDecoderTransformer.currentTransformerIdx");
        this.messageProcessingTreeAttribute = this.attributeBuilder.createAttribute(MESSAGE_PROCESSING_TREE_ATTR_NAME);
    }

    public Class<E> getMessageClass() {
        return this.messageClass;
    }

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage storage, E input, Buffer output) throws TransformationException {
        MemoryManager memoryManager = null;
        boolean isAllocated = false;
        if (output == null) {
            memoryManager = this.obtainMemoryManager(storage);
            if (memoryManager != null) {
                output = memoryManager.allocate(1024);
                isAllocated = true;
            } else {
                throw new TransformationException("Output Buffer is null and there is no way to allocate one");
            }
        }
        int currentElementIndex = 0;
        ArrayList<Object> processingTree = SmartEncoderTransformer.getValue(storage, this.messageProcessingTreeAttribute);
        if (processingTree == null) {
            processingTree = new ArrayList<Object>();
            processingTree.add(input);
            this.messageProcessingTreeAttribute.set(storage.obtainAttributes(), processingTree);
            currentElementIndex = 0;
        } else {
            currentElementIndex = SmartEncoderTransformer.getValue(storage, this.currentTransformerIdxAttribute);
        }
        while (currentElementIndex < this.encodingSequence.size()) {
            SequenceUnit sequenceUnit = this.encodingSequence.get(currentElementIndex);
            switch (sequenceUnit.getType()) {
                case TRANSFORM: {
                    Object fieldValue;
                    SequenceUnit.TransformUnit transformerUnit = (SequenceUnit.TransformUnit)sequenceUnit;
                    Transformer transformer = transformerUnit.transformer;
                    Object processingObject = processingTree.get(processingTree.size() - 1);
                    try {
                        fieldValue = transformerUnit.field.get(processingObject);
                    }
                    catch (Exception e) {
                        throw new TransformationException(e);
                    }
                    TransformationResult<Buffer> result = transformer.transform(storage, fieldValue, output);
                    TransformationResult.Status status = result.getStatus();
                    if (status == TransformationResult.Status.COMPLETED) {
                        transformer.release(storage);
                        ++currentElementIndex;
                        break;
                    }
                    if (status == TransformationResult.Status.INCOMPLED) {
                        if (isAllocated) {
                            output = memoryManager.reallocate(output, output.capacity() * 2);
                            break;
                        }
                        this.saveStatus(storage, processingTree, currentElementIndex, incompletedResult);
                        return incompletedResult;
                    }
                    transformer.release(storage);
                    return result;
                }
                case STEPIN: {
                    Object stepInObject;
                    SequenceUnit.StepInUnit stepInUnit = (SequenceUnit.StepInUnit)sequenceUnit;
                    Object parentObject = processingTree.get(processingTree.size() - 1);
                    try {
                        stepInObject = stepInUnit.field.get(parentObject);
                    }
                    catch (Exception e) {
                        throw new TransformationException(e);
                    }
                    processingTree.add(stepInObject);
                    ++currentElementIndex;
                    break;
                }
                case STEPOUT: {
                    processingTree.remove(processingTree.size() - 1);
                    ++currentElementIndex;
                }
            }
        }
        TransformationResult<Buffer> result = new TransformationResult<Buffer>(TransformationResult.Status.COMPLETED, output.duplicate().flip());
        this.saveStatus(storage, processingTree, currentElementIndex, result);
        return result;
    }

    @Override
    public void release(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            this.messageProcessingTreeAttribute.remove(holder);
            this.currentTransformerIdxAttribute.remove(holder);
        }
        super.release(storage);
    }

    public Map<Class, Class<? extends Transformer>> getPredefinedTransformers() {
        return this.predefinedTransformers;
    }

    @Override
    public Transformer createTransformer(Class fieldType, Class<? extends Transformer> prefTransformerClass) {
        if (prefTransformerClass != null) {
            return SmartEncoderTransformer.newInstance(prefTransformerClass);
        }
        Class<Transformer> transformerClass = this.getTransformer(fieldType);
        if (transformerClass != null) {
            return SmartEncoderTransformer.newInstance(transformerClass);
        }
        return null;
    }

    private void createTransformerSequence(Class messageClass, List<SequenceUnit> sequence) {
        for (Field field : messageClass.getDeclaredFields()) {
            String prefTransformerTypeName;
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers)) continue;
            Class<?> prefTransformerType = null;
            Codec codec = field.getAnnotation(Codec.class);
            if (codec != null && codec.encoder() != null && (prefTransformerTypeName = codec.encoder()) != null && prefTransformerTypeName.length() > 0) {
                try {
                    prefTransformerType = Class.forName(prefTransformerTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            Class<?> type = field.getType();
            Transformer transformer = this.createTransformer(type, prefTransformerType);
            field.setAccessible(true);
            if (transformer != null) {
                this.initializeTransformer(transformer, field);
                sequence.add(new SequenceUnit.TransformUnit(transformer, field));
                continue;
            }
            sequence.add(new SequenceUnit.StepInUnit(field));
            this.createTransformerSequence(type, sequence);
            sequence.add(new SequenceUnit.StepOutUnit());
        }
    }

    private void initializePredefinedTransformers() {
        this.predefinedTransformers = new HashMap<Class, Class<? extends Transformer>>();
        this.predefinedTransformers.put(Byte.class, ByteEncoder.class);
        this.predefinedTransformers.put(Byte.TYPE, ByteEncoder.class);
        this.predefinedTransformers.put(Short.class, ShortEncoder.class);
        this.predefinedTransformers.put(Short.TYPE, ShortEncoder.class);
        this.predefinedTransformers.put(Character.class, CharEncoder.class);
        this.predefinedTransformers.put(Character.TYPE, CharEncoder.class);
        this.predefinedTransformers.put(Integer.class, IntegerEncoder.class);
        this.predefinedTransformers.put(Integer.TYPE, IntegerEncoder.class);
        this.predefinedTransformers.put(Long.class, LongEncoder.class);
        this.predefinedTransformers.put(Long.TYPE, LongEncoder.class);
        this.predefinedTransformers.put(Float.class, FloatEncoder.class);
        this.predefinedTransformers.put(Float.TYPE, FloatEncoder.class);
        this.predefinedTransformers.put(Double.class, DoubleEncoder.class);
        this.predefinedTransformers.put(Double.TYPE, DoubleEncoder.class);
        this.predefinedTransformers.put(String.class, SmartStringEncoder.class);
        this.predefinedTransformers.put(Array.class, ArrayEncoder.class);
    }

    private void saveStatus(AttributeStorage storage, List messageProcessingTree, int index, TransformationResult<Buffer> lastResult) {
        SmartEncoderTransformer.setValue(storage, this.currentTransformerIdxAttribute, index);
        SmartEncoderTransformer.setValue(storage, this.messageProcessingTreeAttribute, messageProcessingTree);
        SmartEncoderTransformer.setValue(storage, this.lastResultAttribute, lastResult);
    }

    protected Class<? extends Transformer> getTransformer(Class clazz) {
        if (clazz.isArray()) {
            return this.predefinedTransformers.get(Array.class);
        }
        return this.predefinedTransformers.get(clazz);
    }

    private void initializeTransformer(Transformer transformer, Field field) {
        if (transformer instanceof SmartMemberTransformer) {
            ((SmartMemberTransformer)transformer).initialize(this, field);
        }
    }

    private static <E> E newInstance(Class<E> clazz) {
        try {
            E instance = clazz.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not initialize class: " + clazz.getName(), e);
        }
    }
}

