/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandlerAdapter;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.PostProcessor;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.ProcessorRunnable;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.SocketBinder;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import org.glassfish.grizzly.asyncqueue.AsyncQueueIO;
import org.glassfish.grizzly.asyncqueue.AsyncQueueReader;
import org.glassfish.grizzly.asyncqueue.AsyncQueueWriter;
import org.glassfish.grizzly.filterchain.DefaultFilterChain;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainEnabledTransport;
import org.glassfish.grizzly.filterchain.FilterChainFactory;
import org.glassfish.grizzly.filterchain.PatternFilterChainFactory;
import org.glassfish.grizzly.filterchain.SingletonFilterChainFactory;
import org.glassfish.grizzly.nio.AbstractNIOTransport;
import org.glassfish.grizzly.nio.DefaultSelectionKeyHandler;
import org.glassfish.grizzly.nio.DefaultSelectorHandler;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorIO;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorPool;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOAsyncQueueReader;
import org.glassfish.grizzly.nio.transport.UDPNIOAsyncQueueWriter;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.UDPNIOMessageTransportFilter;
import org.glassfish.grizzly.nio.transport.UDPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOStreamTransportFilter;
import org.glassfish.grizzly.nio.transport.UDPNIOTemporarySelectorReader;
import org.glassfish.grizzly.nio.transport.UDPNIOTemporarySelectorWriter;
import org.glassfish.grizzly.strategies.WorkerThreadStrategy;
import org.glassfish.grizzly.threadpool.DefaultThreadPool;
import org.glassfish.grizzly.threadpool.ExtendedThreadPool;

public class UDPNIOTransport
extends AbstractNIOTransport
implements SocketBinder,
SocketConnectorHandler,
AsyncQueueEnabledTransport,
FilterChainEnabledTransport,
TemporarySelectorsEnabledTransport {
    private Logger logger = Grizzly.logger;
    private static final String DEFAULT_TRANSPORT_NAME = "UDPNIOTransport";
    private static final int DEFAULT_SELECTOR_RUNNERS_COUNT = 2;
    protected int serverSocketSoTimeout = 0;
    protected boolean reuseAddress = true;
    protected int connectionTimeout = 30000;
    protected final Collection<UDPNIOServerConnection> serverConnections;
    protected FilterChainFactory filterChainFactory;
    protected AsyncQueueIO asyncQueueIO;
    protected TemporarySelectorIO temporarySelectorIO;
    private final Filter streamTransportFilter;
    private final Filter messageTransportFilter;
    protected final RegisterChannelCompletionHandler registerChannelCompletionHandler;
    private final EnableInterestPostProcessor enablingInterestPostProcessor;

    public UDPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    public UDPNIOTransport(String name) {
        super(name);
        this.readBufferSize = -1;
        this.writeBufferSize = -1;
        this.registerChannelCompletionHandler = new RegisterChannelCompletionHandler();
        this.enablingInterestPostProcessor = new EnableInterestPostProcessor();
        this.asyncQueueIO = new AsyncQueueIO(new UDPNIOAsyncQueueReader(this), new UDPNIOAsyncQueueWriter(this));
        this.temporarySelectorIO = new TemporarySelectorIO(new UDPNIOTemporarySelectorReader(this), new UDPNIOTemporarySelectorWriter(this));
        SingletonFilterChainFactory patternFactory = new SingletonFilterChainFactory();
        DefaultFilterChain filterChain = new DefaultFilterChain(patternFactory);
        patternFactory.setFilterChainPattern(filterChain);
        this.filterChainFactory = patternFactory;
        this.streamTransportFilter = new UDPNIOStreamTransportFilter(this);
        this.messageTransportFilter = new UDPNIOMessageTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<UDPNIOServerConnection>();
    }

    @Override
    public UDPNIOServerConnection bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public UDPNIOServerConnection bind(String host, int port) throws IOException {
        return this.bind(host, port, 50);
    }

    @Override
    public UDPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UDPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            DatagramChannel serverSocketChannel = DatagramChannel.open();
            UDPNIOServerConnection serverConnection = new UDPNIOServerConnection(this, serverSocketChannel);
            this.serverConnections.add(serverConnection);
            DatagramSocket socket = serverSocketChannel.socket();
            socket.setReuseAddress(this.reuseAddress);
            socket.setSoTimeout(this.serverSocketSoTimeout);
            socket.bind(socketAddress);
            serverSocketChannel.configureBlocking(false);
            if (!this.isStopped()) {
                serverConnection.register();
            }
            UDPNIOServerConnection uDPNIOServerConnection = serverConnection;
            return uDPNIOServerConnection;
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Connection connection) throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            if (connection != null && this.serverConnections.remove((UDPNIOServerConnection)connection)) {
                connection.close();
            }
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            this.stopServerConnections();
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    public Future<Connection> connect() throws IOException {
        return this.connect(null, null);
    }

    @Override
    public Future<Connection> connect(String host, int port) throws IOException {
        return this.connect(new InetSocketAddress(host, port));
    }

    @Override
    public Future<Connection> connect(SocketAddress remoteAddress) throws IOException {
        return this.connect(remoteAddress, null);
    }

    @Override
    public Future<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        UDPNIOConnectorHandler connectorHandler = new UDPNIOConnectorHandler(this);
        return connectorHandler.connect(remoteAddress, localAddress);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel instanceof DatagramChannel) {
            DatagramSocket socket = ((DatagramChannel)nioChannel).socket();
            socket.close();
        }
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                Grizzly.logger.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter writer;
            AsyncQueueReader reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            Transport.State currentState = (Transport.State)((Object)this.state.getState(false));
            if (currentState != Transport.State.STOP) {
                Grizzly.logger.log(Level.WARNING, "Transport is not in STOP or BOUND state!");
            }
            this.state.setState(Transport.State.STARTING);
            if (this.selectorHandler == null) {
                this.selectorHandler = new DefaultSelectorHandler();
            }
            if (this.selectionKeyHandler == null) {
                this.selectionKeyHandler = new DefaultSelectionKeyHandler();
            }
            if (this.processor == null && this.processorSelector == null) {
                this.processor = this.getFilterChainFactory().create();
            }
            if (this.selectorRunnersCount <= 0) {
                this.selectorRunnersCount = 2;
            }
            if (this.nioChannelDistributor == null) {
                this.nioChannelDistributor = new RoundRobinConnectionDistributor(this);
            }
            if (this.strategy == null) {
                this.strategy = new WorkerThreadStrategy(this);
            }
            if (this.internalThreadPool == null) {
                this.internalThreadPool = new DefaultThreadPool(this.selectorRunnersCount * 2, this.selectorRunnersCount * 4, 1, 5L, TimeUnit.SECONDS);
            }
            if (this.workerThreadPool == null) {
                this.workerThreadPool = new DefaultThreadPool();
            }
            int selectorPoolSize = 20;
            if (this.workerThreadPool instanceof ExtendedThreadPool) {
                selectorPoolSize = ((ExtendedThreadPool)((Object)this.workerThreadPool)).getMaximumPoolSize();
            }
            this.temporarySelectorIO.setSelectorPool(new TemporarySelectorPool(selectorPoolSize));
            this.startSelectorRunners();
            this.registerServerConnections();
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    private void registerServerConnections() {
        for (UDPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                serverConnection.register();
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception occurred when starting server connection: " + serverConnection, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            this.state.setState(Transport.State.STOP);
            this.stopSelectorRunners();
            if (this.internalThreadPool != null) {
                this.internalThreadPool.shutdown();
                this.internalThreadPool = null;
            }
            this.stopServerConnections();
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    private void stopServerConnections() {
        for (UDPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                serverConnection.close();
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, "Exception occurred when closing server connection: " + serverConnection, e);
            }
        }
        this.serverConnections.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            if (this.state.getState(false) != Transport.State.START) {
                Grizzly.logger.log(Level.WARNING, "Transport is not in START state!");
            }
            this.state.setState(Transport.State.PAUSE);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            if (this.state.getState(false) != Transport.State.PAUSE) {
                Grizzly.logger.log(Level.WARNING, "Transport is not in PAUSE state!");
            }
            this.state.setState(Transport.State.START);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    @Override
    public FilterChainFactory getFilterChainFactory() {
        return this.filterChainFactory;
    }

    @Override
    public void setFilterChainFactory(FilterChainFactory factory) {
        this.filterChainFactory = factory;
    }

    @Override
    public FilterChain getFilterChain() {
        FilterChainFactory factory = this.getFilterChainFactory();
        if (factory instanceof PatternFilterChainFactory) {
            return ((PatternFilterChainFactory)factory).getFilterChainPattern();
        }
        throw new IllegalStateException("Transport FilterChainFactory doesn't support creating of FilterChain by a patterns. It means you have to add/remove Filters using FilterChainFactory API: " + factory.getClass().getName());
    }

    @Override
    public Filter getStreamTransportFilter() {
        return this.streamTransportFilter;
    }

    @Override
    public Filter getMessageTransportFilter() {
        return this.messageTransportFilter;
    }

    protected NIOConnection obtainNIOConnection(DatagramChannel channel) {
        UDPNIOConnection connection = new UDPNIOConnection(this, channel);
        connection.configureBlocking(this.isBlocking);
        return connection;
    }

    @Override
    public AsyncQueueIO getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    @Override
    public void setTemporarySelectorIO(TemporarySelectorIO temporarySelectorIO) {
        this.temporarySelectorIO = temporarySelectorIO;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    @Override
    public void fireIOEvent(IOEvent ioEvent, Connection connection, Object strategyContext) throws IOException {
        try {
            if (ioEvent == IOEvent.READ) {
                this.processReadIoEvent(ioEvent, (UDPNIOConnection)connection, strategyContext);
            } else if (ioEvent == IOEvent.WRITE) {
                this.processWriteIoEvent(ioEvent, (UDPNIOConnection)connection, strategyContext);
            } else {
                Processor conProcessor = this.getConnectionProcessor(connection, ioEvent);
                if (conProcessor != null) {
                    this.executeProcessor(ioEvent, connection, conProcessor, null, null, strategyContext);
                } else {
                    ((NIOConnection)connection).disableIOEvent(ioEvent);
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "IOException occurred on fireIOEvent().connection=" + connection + " event=" + (Object)((Object)ioEvent));
            throw e;
        }
        catch (Exception e) {
            String text = new StringBuilder(256).append("Unexpected exception occurred fireIOEvent().").append("connection=").append(connection).append(" event=").append((Object)ioEvent).toString();
            this.logger.log(Level.WARNING, text, e);
            throw new IOException(e.getClass() + ": " + text);
        }
    }

    protected void executeProcessor(IOEvent ioEvent, Connection connection, Processor processor, ProcessorExecutor executor, PostProcessor postProcessor, Object strategyContext) throws IOException {
        ProcessorRunnable processorRunnable = new ProcessorRunnable(ioEvent, connection, processor, postProcessor);
        this.strategy.executeProcessor(strategyContext, processorRunnable);
    }

    private void processReadIoEvent(IOEvent ioEvent, UDPNIOConnection connection, Object strategyContext) throws IOException {
        UDPNIOAsyncQueueReader asyncQueueReader = (UDPNIOAsyncQueueReader)this.getAsyncQueueIO().getReader();
        if (asyncQueueReader == null || !asyncQueueReader.isReady(connection)) {
            this.executeDefaultProcessor(ioEvent, connection, strategyContext);
        } else {
            connection.disableIOEvent(ioEvent);
            this.executeProcessor(ioEvent, connection, asyncQueueReader, null, null, strategyContext);
        }
    }

    private void processWriteIoEvent(IOEvent ioEvent, UDPNIOConnection connection, Object strategyContext) throws IOException {
        AsyncQueueWriter asyncQueueWriter = this.getAsyncQueueIO().getWriter();
        if (asyncQueueWriter == null || !asyncQueueWriter.isReady(connection)) {
            this.executeDefaultProcessor(ioEvent, connection, strategyContext);
        } else {
            connection.disableIOEvent(ioEvent);
            this.executeProcessor(ioEvent, connection, asyncQueueWriter, null, null, strategyContext);
        }
    }

    private void executeDefaultProcessor(IOEvent ioEvent, UDPNIOConnection connection, Object strategyContext) throws IOException {
        connection.disableIOEvent(ioEvent);
        Processor conProcessor = this.getConnectionProcessor(connection, ioEvent);
        if (conProcessor != null) {
            this.executeProcessor(ioEvent, connection, conProcessor, null, this.enablingInterestPostProcessor, strategyContext);
        }
    }

    Processor getConnectionProcessor(Connection connection, IOEvent ioEvent) {
        Processor conProcessor = connection.getProcessor();
        ProcessorSelector conProcessorSelector = connection.getProcessorSelector();
        if (!(conProcessor != null && conProcessor.isInterested(ioEvent) || conProcessorSelector == null)) {
            conProcessor = conProcessorSelector.select(ioEvent, connection);
        }
        return conProcessor;
    }

    public int read(Connection connection, Buffer buffer) throws IOException {
        return this.read(connection, buffer, null);
    }

    public int read(Connection connection, Buffer buffer, ReadResult currentResult) throws IOException {
        int read = 0;
        boolean isAllocated = false;
        if (buffer == null && currentResult != null) {
            buffer = this.memoryManager.allocate(connection.getReadBufferSize());
            isAllocated = true;
        }
        int initialPos = buffer.position();
        SocketAddress srcAddress = null;
        if (buffer.hasRemaining()) {
            UDPNIOConnection udpConnection = (UDPNIOConnection)connection;
            srcAddress = ((DatagramChannel)udpConnection.getChannel()).receive((ByteBuffer)buffer.underlying());
            read = buffer.position() - initialPos;
        }
        if (isAllocated) {
            if (read > 0) {
                buffer.trim();
                buffer.position(buffer.limit());
            } else {
                buffer.dispose();
                buffer = null;
            }
        }
        if (currentResult != null && read >= 0) {
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + read);
            currentResult.setSrcAddress(srcAddress);
        }
        return read;
    }

    public int write(Connection connection, SocketAddress dstAddress, Buffer buffer) throws IOException {
        return this.write(connection, dstAddress, buffer, null);
    }

    public int write(Connection connection, SocketAddress dstAddress, Buffer buffer, WriteResult currentResult) throws IOException {
        UDPNIOConnection udpConnection = (UDPNIOConnection)connection;
        int written = dstAddress != null ? ((DatagramChannel)udpConnection.getChannel()).send((ByteBuffer)buffer.underlying(), dstAddress) : ((DatagramChannel)udpConnection.getChannel()).write((ByteBuffer)buffer.underlying());
        if (currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
            currentResult.setDstAddress(connection.getPeerAddress());
        }
        return written;
    }

    protected class RegisterChannelCompletionHandler
    extends CompletionHandlerAdapter<RegisterChannelResult> {
        protected RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(Connection c, RegisterChannelResult result) {
            try {
                SelectionKey selectionKey = result.getSelectionKey();
                UDPNIOConnection connection = (UDPNIOConnection)UDPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
                if (connection != null) {
                    SelectorRunner selectorRunner = result.getSelectorRunner();
                    connection.setSelectionKey(selectionKey);
                    connection.setSelectorRunner(selectorRunner);
                }
            }
            catch (Exception e) {
                Grizzly.logger.log(Level.FINE, "Exception happened, when trying to register the channel", e);
            }
        }
    }

    public class EnableInterestPostProcessor
    implements PostProcessor {
        public void process(ProcessorResult result, Context context) throws IOException {
            if (result == null || result.getStatus() == ProcessorResult.Status.OK) {
                IOEvent ioEvent = context.getIoEvent();
                ((NIOConnection)context.getConnection()).enableIOEvent(ioEvent);
            }
        }
    }
}

