/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.nio.tmpselectors.TemporarySelectorWriter;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.streams.AbstractStreamWriter;
import org.glassfish.grizzly.streams.AddressableStreamWriter;

public class UDPNIOStreamWriter
extends AbstractStreamWriter
implements AddressableStreamWriter<SocketAddress> {
    private SocketAddress peerAddress;
    private int sentBytesCounter;

    public UDPNIOStreamWriter(UDPNIOConnection connection) {
        super(connection);
    }

    @Override
    public Future<Integer> flush(SocketAddress peerAddress, CompletionHandler<Integer> completionHandler) throws IOException {
        this.setPeerAddress(peerAddress);
        return this.flush(completionHandler);
    }

    @Override
    public Future<Integer> flush(CompletionHandler<Integer> completionHandler) throws IOException {
        return super.flush(new ResetCounterCompletionHandler(completionHandler));
    }

    @Override
    protected Future<Integer> flush0(Buffer current, CompletionHandler<Integer> completionHandler) throws IOException {
        current.flip();
        UDPNIOConnection connection = (UDPNIOConnection)this.getConnection();
        UDPNIOTransport transport = (UDPNIOTransport)connection.getTransport();
        if (this.isBlocking()) {
            TemporarySelectorWriter writer = (TemporarySelectorWriter)transport.getTemporarySelectorIO().getWriter();
            Future<WriteResult<Buffer, SocketAddress>> future = writer.write(connection, this.peerAddress, current, new CompletionHandlerAdapter(null, completionHandler), null, this.getTimeout(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            try {
                return new ReadyFutureImpl<Integer>(future.get().getWrittenSize());
            }
            catch (Exception e) {
                throw new IOException("UDPNIOStreamWriter.flush0(): unexpected exception. " + e.getMessage());
            }
        }
        FutureImpl<Integer> future = new FutureImpl<Integer>();
        transport.getAsyncQueueIO().getWriter().write((Connection)connection, this.peerAddress, current, new CompletionHandlerAdapter(future, completionHandler));
        return future;
    }

    @Override
    protected Future<Integer> close0(final CompletionHandler<Integer> completionHandler) throws IOException {
        if (this.buffer != null && this.buffer.position() > 0) {
            final FutureImpl<Integer> future = new FutureImpl<Integer>();
            try {
                this.overflow(new CompletionHandler<Integer>(){

                    @Override
                    public void cancelled(Connection connection) {
                        this.close(ZERO);
                    }

                    @Override
                    public void failed(Connection connection, Throwable throwable) {
                        this.close(ZERO);
                    }

                    @Override
                    public void completed(Connection connection, Integer result) {
                        this.close(result);
                    }

                    @Override
                    public void updated(Connection connection, Integer result) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close(Integer result) {
                        try {
                            UDPNIOStreamWriter.this.getConnection().close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (completionHandler != null) {
                                completionHandler.completed(null, result);
                            }
                            future.setResult(result);
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return future;
        }
        if (completionHandler != null) {
            completionHandler.completed(null, ZERO);
        }
        return new ReadyFutureImpl<Integer>(ZERO);
    }

    @Override
    public SocketAddress getPeerAddress() {
        UDPNIOConnection connection = (UDPNIOConnection)this.getConnection();
        if (connection.isConnected()) {
            return connection.getPeerAddress();
        }
        return this.peerAddress;
    }

    @Override
    public void setPeerAddress(SocketAddress peerAddress) {
        UDPNIOConnection connection = (UDPNIOConnection)this.getConnection();
        if (connection.isConnected()) {
            throw new IllegalStateException("UDP connection is already connected!");
        }
        this.peerAddress = peerAddress;
    }

    private final class ResetCounterCompletionHandler
    implements CompletionHandler<Integer> {
        private final CompletionHandler<Integer> parentCompletionHandler;

        public ResetCounterCompletionHandler(CompletionHandler<Integer> parentCompletionHandler) {
            this.parentCompletionHandler = parentCompletionHandler;
        }

        @Override
        public void cancelled(Connection connection) {
            UDPNIOStreamWriter.this.peerAddress = null;
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.cancelled(connection);
            }
        }

        @Override
        public void failed(Connection connection, Throwable throwable) {
            UDPNIOStreamWriter.this.peerAddress = null;
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.failed(connection, throwable);
            }
        }

        @Override
        public void completed(Connection connection, Integer result) {
            UDPNIOStreamWriter.this.sentBytesCounter = 0;
            UDPNIOStreamWriter.this.peerAddress = null;
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.completed(connection, result);
            }
        }

        @Override
        public void updated(Connection connection, Integer result) {
            UDPNIOStreamWriter.this.peerAddress = null;
            if (this.parentCompletionHandler != null) {
                this.parentCompletionHandler.updated(connection, result);
            }
        }
    }

    private final class CompletionHandlerAdapter
    implements CompletionHandler<WriteResult<Buffer, SocketAddress>> {
        private final FutureImpl<Integer> future;
        private final CompletionHandler<Integer> completionHandler;

        public CompletionHandlerAdapter(FutureImpl<Integer> future, CompletionHandler<Integer> completionHandler) {
            this.future = future;
            this.completionHandler = completionHandler;
        }

        @Override
        public void cancelled(Connection connection) {
            if (this.completionHandler != null) {
                this.completionHandler.cancelled(connection);
            }
            if (this.future != null) {
                this.future.cancel(false);
            }
        }

        @Override
        public void failed(Connection connection, Throwable throwable) {
            if (this.completionHandler != null) {
                this.completionHandler.failed(connection, throwable);
            }
            if (this.future != null) {
                this.future.failure(throwable);
            }
        }

        @Override
        public void completed(Connection connection, WriteResult result) {
            UDPNIOStreamWriter.this.sentBytesCounter += result.getWrittenSize();
            int totalSentBytes = UDPNIOStreamWriter.this.sentBytesCounter;
            if (this.completionHandler != null) {
                this.completionHandler.completed(connection, totalSentBytes);
            }
            if (this.future != null) {
                this.future.setResult(totalSentBytes);
            }
        }

        @Override
        public void updated(Connection connection, WriteResult result) {
            if (this.completionHandler != null) {
                this.completionHandler.updated(connection, UDPNIOStreamWriter.this.sentBytesCounter + result.getWrittenSize());
            }
        }
    }
}

