/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.filterchain.FilterAdapter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.nio.transport.UDPNIOConnection;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;

public class UDPNIOMessageTransportFilter
extends FilterAdapter {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final UDPNIOTransport transport;

    UDPNIOMessageTransportFilter(UDPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        UDPNIOConnection connection = (UDPNIOConnection)ctx.getConnection();
        ReadResult readResult = new ReadResult(connection);
        this.transport.read(connection, null, readResult);
        if (readResult.getReadSize() > 0) {
            Buffer buffer = ((Buffer)readResult.getMessage()).flip();
            SocketAddress address = (SocketAddress)readResult.getSrcAddress();
            ctx.setMessage(buffer);
            ctx.setAddress(address);
            if (!connection.isConnected()) {
                ctx.getProcessorRunnable().setPostProcessor(null);
                connection.enableIOEvent(IOEvent.READ);
            }
        } else {
            return ctx.getStopAction();
        }
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Object message = ctx.getMessage();
        Object dstAddress = ctx.getAddress();
        if (message != null) {
            Connection connection = ctx.getConnection();
            this.transport.write(connection, (SocketAddress)dstAddress, (Buffer)message);
        }
        return nextAction;
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

