/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio.transport;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.grizzly.AbstractProcessor;
import org.glassfish.grizzly.AbstractSocketConnectorHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.RegisterChannelResult;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public class TCPNIOConnectorHandler
extends AbstractSocketConnectorHandler {
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    protected boolean isReuseAddress;
    protected int connectionTimeout = 30000;

    public TCPNIOConnectorHandler(TCPNIOTransport transport) {
        super(transport);
        TCPNIOTransport nioTransport = transport;
        this.connectionTimeout = nioTransport.getConnectionTimeout();
        this.isReuseAddress = nioTransport.isReuseAddress();
    }

    @Override
    public Future<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        if (!this.transport.isBlocking()) {
            return this.connectAsync(remoteAddress, localAddress);
        }
        return this.connectSync(remoteAddress, localAddress);
    }

    protected Future<Connection> connectSync(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        Future<Connection> future = this.connectAsync(remoteAddress, localAddress);
        this.waitNIOFuture(future);
        return future;
    }

    protected Future<Connection> connectAsync(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        Socket socket = socketChannel.socket();
        socket.setReuseAddress(this.isReuseAddress);
        if (localAddress != null) {
            socket.bind(localAddress);
        }
        socketChannel.configureBlocking(false);
        TCPNIOTransport nioTransport = (TCPNIOTransport)this.transport;
        TCPNIOConnection newConnection = (TCPNIOConnection)nioTransport.obtainNIOConnection(socketChannel);
        FutureImpl<Connection> connectFuture = new FutureImpl<Connection>();
        ConnectorEventProcessor finishConnectProcessor = new ConnectorEventProcessor(connectFuture);
        newConnection.setProcessor(finishConnectProcessor);
        try {
            boolean isConnected = socketChannel.connect(remoteAddress);
            if (isConnected) {
                Future<RegisterChannelResult> registerChannelFuture = nioTransport.getNioChannelDistributor().registerChannelAsync(socketChannel, 1, newConnection, null);
                RegisterChannelResult result = this.waitNIOFuture(registerChannelFuture);
                nioTransport.registerChannelCompletionHandler.completed((Connection)null, result);
                this.transport.fireIOEvent(IOEvent.CONNECTED, newConnection);
            } else {
                Future<RegisterChannelResult> registerChannelFuture = nioTransport.getNioChannelDistributor().registerChannelAsync(socketChannel, 8, newConnection, nioTransport.registerChannelCompletionHandler);
                this.waitNIOFuture(registerChannelFuture);
            }
        }
        catch (IOException e) {
            return new ReadyFutureImpl<Connection>(e);
        }
        return connectFuture;
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean isReuseAddress) {
        this.isReuseAddress = isReuseAddress;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected <E> E waitNIOFuture(Future<E> future) throws IOException {
        try {
            return future.get(this.connectionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IOException("Connection was interrupted!");
        }
        catch (TimeoutException e) {
            throw new IOException("Channel registration on Selector timeout!");
        }
        catch (ExecutionException e) {
            Throwable internalException = e.getCause();
            if (internalException instanceof IOException) {
                throw (IOException)internalException;
            }
            throw new IOException("Unexpected exception connection exception. " + internalException.getClass().getName() + ": " + internalException.getMessage());
        }
        catch (CancellationException e) {
            throw new IOException("Connection was cancelled!");
        }
    }

    protected class ConnectorEventProcessor
    extends AbstractProcessor {
        private FutureImpl<Connection> connectFuture;

        public ConnectorEventProcessor(FutureImpl<Connection> future) {
            this.connectFuture = future;
        }

        @Override
        public ProcessorResult process(Context context) throws IOException {
            try {
                NIOConnection connection = (NIOConnection)context.getConnection();
                TCPNIOTransport transport = (TCPNIOTransport)connection.getTransport();
                SocketChannel channel = (SocketChannel)connection.getChannel();
                if (!channel.isConnected()) {
                    channel.finishConnect();
                }
                transport.getSelectorHandler().unregisterKey(connection.getSelectorRunner(), connection.getSelectionKey(), 8);
                transport.configureChannel(channel);
                connection.setProcessor(TCPNIOConnectorHandler.this.defaultProcessor);
                connection.setProcessorSelector(TCPNIOConnectorHandler.this.defaultProcessorSelector);
                transport.fireIOEvent(IOEvent.CONNECTED, connection);
                transport.getSelectorHandler().registerKey(connection.getSelectorRunner(), connection.getSelectionKey(), 1);
                this.connectFuture.setResult(connection);
            }
            catch (Exception e) {
                this.connectFuture.failure(e);
            }
            return null;
        }

        @Override
        public boolean isInterested(IOEvent ioEvent) {
            return true;
        }

        @Override
        public void setInterested(IOEvent ioEvent, boolean isInterested) {
        }
    }
}

