/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorSelector;
import org.glassfish.grizzly.ReadResult;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueue;
import org.glassfish.grizzly.asyncqueue.AsyncReadQueueRecord;
import org.glassfish.grizzly.asyncqueue.AsyncWriteQueueRecord;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.IndexedAttributeHolder;
import org.glassfish.grizzly.nio.AbstractNIOTransport;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.streams.StreamWriter;

public abstract class AbstractNIOConnection
implements NIOConnection {
    protected final NIOTransport transport;
    protected int readBufferSize;
    protected int writeBufferSize;
    protected SelectorRunner selectorRunner;
    protected SelectableChannel channel;
    protected SelectionKey selectionKey;
    protected Processor processor;
    protected ProcessorSelector processorSelector;
    protected final AttributeHolder attributes;
    protected final AsyncQueue<AsyncReadQueueRecord> asyncReadQueue;
    protected final AsyncQueue<AsyncWriteQueueRecord> asyncWriteQueue;
    protected AtomicBoolean isClosed = new AtomicBoolean(false);
    protected boolean isBlocking;

    public AbstractNIOConnection(NIOTransport transport) {
        this.transport = transport;
        this.asyncReadQueue = new AsyncQueue();
        this.asyncWriteQueue = new AsyncQueue();
        this.attributes = new IndexedAttributeHolder(transport.getAttributeBuilder());
    }

    @Override
    public void configureBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    @Override
    public SelectorRunner getSelectorRunner() {
        return this.selectorRunner;
    }

    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        this.selectorRunner = selectorRunner;
    }

    @Override
    public SelectableChannel getChannel() {
        return this.channel;
    }

    protected void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    protected void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
        this.setChannel(selectionKey.channel());
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor preferableProcessor) {
        this.processor = preferableProcessor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector preferableProcessorSelector) {
        this.processorSelector = preferableProcessorSelector;
    }

    public AsyncQueue<AsyncReadQueueRecord> getAsyncReadQueue() {
        return this.asyncReadQueue;
    }

    public AsyncQueue<AsyncWriteQueueRecord> getAsyncWriteQueue() {
        return this.asyncWriteQueue;
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    @Override
    public AttributeHolder obtainAttributes() {
        return this.attributes;
    }

    @Override
    public Future<ReadResult<Buffer, SocketAddress>> read() throws IOException {
        return this.read(null);
    }

    @Override
    public Future<ReadResult<Buffer, SocketAddress>> read(Buffer buffer) throws IOException {
        return this.read(buffer, (CompletionHandler<ReadResult<Buffer, SocketAddress>>)null);
    }

    @Override
    public Future<ReadResult<Buffer, SocketAddress>> read(Buffer buffer, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler) throws IOException {
        return this.read(buffer, completionHandler, null);
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(Buffer buffer) throws IOException {
        return this.write(null, buffer);
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler) throws IOException {
        return this.write(null, buffer, completionHandler);
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(SocketAddress dstAddress, Buffer buffer) throws IOException {
        return this.write(dstAddress, buffer, null);
    }

    @Override
    public boolean isOpen() {
        return this.channel != null && this.channel.isOpen() && !this.isClosed.get();
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed.getAndSet(true)) {
            StreamReader reader;
            this.preClose();
            StreamWriter writer = this.getStreamWriter();
            if (writer != null) {
                writer.close();
            }
            if ((reader = this.getStreamReader()) != null) {
                reader.close();
            }
            ((AbstractNIOTransport)this.transport).closeConnection(this);
        }
    }

    protected abstract void preClose();

    @Override
    public void enableIOEvent(IOEvent ioEvent) throws IOException {
        SelectionKeyHandler selectionKeyHandler = this.transport.getSelectionKeyHandler();
        int interest = selectionKeyHandler.ioEvent2SelectionKeyInterest(ioEvent);
        if (interest == 0) {
            return;
        }
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.registerKey(this.selectorRunner, this.selectionKey, selectionKeyHandler.ioEvent2SelectionKeyInterest(ioEvent));
    }

    @Override
    public void disableIOEvent(IOEvent ioEvent) throws IOException {
        SelectionKeyHandler selectionKeyHandler = this.transport.getSelectionKeyHandler();
        int interest = selectionKeyHandler.ioEvent2SelectionKeyInterest(ioEvent);
        if (interest == 0) {
            return;
        }
        SelectorHandler selectorHandler = this.transport.getSelectorHandler();
        selectorHandler.unregisterKey(this.selectorRunner, this.selectionKey, interest);
    }
}

