/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory.slab;

import java.io.Closeable;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.memory.slab.SlabMemoryManagerImpl;
import org.glassfish.grizzly.memory.slab.SlabPoolImpl;
import org.glassfish.grizzly.memory.slab.SlabPoolMemoryManagerImpl;

public class SlabMemoryManagerFactory {
    public static final int DEFAULT_SLAB_SIZE = 524288;
    public static final long DEFAULT_POOL_MAX_SIZE = 0x780000L;
    public static final long DEFAULT_POOL_MIN_SIZE = 0x280000L;
    public static final boolean DEFAULT_BYTE_BUFFER_TYPE = false;

    public static MemoryManager makeAllocator(int allocatorSize, boolean bufferType) {
        return new SlabMemoryManagerImpl(allocatorSize, bufferType);
    }

    private SlabMemoryManagerFactory() {
    }

    public static MemoryManager makeAllocator() {
        return new SlabMemoryManagerImpl(524288, false);
    }

    public static MemoryManager makePoolAllocator(SlabPool pool) {
        return new SlabPoolMemoryManagerImpl(pool);
    }

    public static SlabPool makeSlabPool(int maxAllocationSize, long minSize, long maxSize, boolean bufferType) {
        return new SlabPoolImpl(maxAllocationSize, minSize, maxSize, bufferType);
    }

    public static SlabPool makeDefaultSlabPool() {
        return new SlabPoolImpl(524288, 0x280000L, 0x780000L, false);
    }

    public static interface SlabPool
    extends Closeable {
        public int maxAllocationSize();

        public boolean bufferType();

        public int numFreeSlabs();

        public int numPartialSlabs();

        public int numFullSlabs();

        public long minSize();

        public long maxSize();

        public long freeSpace();

        public long unavailableSpace();

        public long allocatedSpace();
    }
}

