/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory.slab;

import java.nio.ByteBuffer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.memory.ByteBufferManager;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.slab.Slab;
import org.glassfish.grizzly.memory.slab.SlabByteBufferWrapper;
import org.glassfish.grizzly.threadpool.WorkerThread;

public abstract class SlabMemoryManagerBase
extends ByteBufferManager {
    private SlabAssociation slabThreadAssociation = new SlabThreadAssociation(this);
    private SlabAssociation slabWorkerThreadAssociation = new SlabWorkerThreadAssociation(this);

    SlabMemoryManagerBase() {
    }

    public abstract void dispose(Slab var1, ByteBuffer var2);

    abstract void releaseSlab(Slab var1);

    abstract Slab obtainSlab();

    public abstract int maxAllocationSize();

    @Override
    public SlabByteBufferWrapper allocate(int size) {
        if (size > this.maxAllocationSize()) {
            throw new IllegalArgumentException("Request size " + size + " is larger than maximum allocation size " + this.maxAllocationSize());
        }
        Slab currentSlab = this.obtainCurrentThreadSlab();
        if (currentSlab.sizeAvailable() < size) {
            currentSlab.markFull();
            this.releaseSlab(currentSlab);
            currentSlab = this.obtainSlab();
            this.associateThread(currentSlab);
        }
        return new SlabByteBufferWrapper(this, currentSlab, size);
    }

    public final Buffer allocate(int minSize, int maxSize) {
        if (minSize > this.maxAllocationSize()) {
            throw new IllegalArgumentException("Minimum request size " + minSize + " is larger than maximum allocation size " + this.maxAllocationSize());
        }
        int remaining = this.obtainCurrentThreadSlab().sizeAvailable();
        int allocSize = maxSize;
        if (remaining >= minSize && remaining <= maxSize) {
            allocSize = remaining;
        }
        return this.allocate(allocSize);
    }

    @Override
    public void release(ByteBufferWrapper buffer) {
    }

    @Override
    public ByteBufferWrapper reallocate(ByteBufferWrapper oldBuffer, int newSize) {
        return null;
    }

    private Slab getCurrentThreadSlab() {
        return this.getSlabAssociation().getSlab();
    }

    private Slab obtainCurrentThreadSlab() {
        return this.getSlabAssociation().obtainSlab();
    }

    private void associateThread(Slab slab) {
        this.getSlabAssociation().associate(slab);
    }

    private SlabAssociation getSlabAssociation() {
        Thread thread = Thread.currentThread();
        SlabAssociation result = thread instanceof WorkerThread ? this.slabWorkerThreadAssociation : this.slabThreadAssociation;
        return result;
    }

    private class SlabWorkerThreadAssociation
    implements SlabAssociation {
        Attribute<Slab> threadAssociatedSlab = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("SlabMemoryManagerBase.slab");
        private SlabMemoryManagerBase manager;

        private SlabWorkerThreadAssociation(SlabMemoryManagerBase manager) {
            this.manager = manager;
        }

        @Override
        public Slab getSlab() {
            WorkerThread thread = (WorkerThread)((Object)Thread.currentThread());
            return this.threadAssociatedSlab.get(thread);
        }

        @Override
        public Slab obtainSlab() {
            WorkerThread thread = (WorkerThread)((Object)Thread.currentThread());
            Slab currentSlab = this.threadAssociatedSlab.get(thread);
            if (currentSlab == null) {
                currentSlab = this.manager.obtainSlab();
                this.threadAssociatedSlab.set(thread, currentSlab);
            }
            return currentSlab;
        }

        @Override
        public void associate(Slab slab) {
            WorkerThread thread = (WorkerThread)((Object)Thread.currentThread());
            AttributeHolder workerThreadAttributes = thread.obtainAttributes();
            this.threadAssociatedSlab.set(workerThreadAttributes, slab);
        }
    }

    private class SlabThreadAssociation
    implements SlabAssociation {
        private ThreadLocalSlab threadLocalSlab = new ThreadLocalSlab();
        private SlabMemoryManagerBase manager;

        private SlabThreadAssociation(SlabMemoryManagerBase manager) {
            this.manager = manager;
        }

        @Override
        public Slab getSlab() {
            return this.threadLocalSlab.getSlab();
        }

        @Override
        public Slab obtainSlab() {
            Slab slab = this.threadLocalSlab.getSlab();
            if (slab == null) {
                slab = this.manager.obtainSlab();
                this.associate(slab);
            }
            return slab;
        }

        @Override
        public void associate(Slab slab) {
            this.threadLocalSlab.set(slab);
        }

        private class ThreadLocalSlab
        extends ThreadLocal {
            private ThreadLocalSlab() {
            }

            public Object initialValue() {
                return null;
            }

            public Slab getSlab() {
                return (Slab)super.get();
            }
        }
    }

    static interface SlabAssociation {
        public Slab getSlab();

        public Slab obtainSlab();

        public void associate(Slab var1);
    }
}

