/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory.slab;

import org.glassfish.grizzly.memory.ByteBufferManager;
import org.glassfish.grizzly.memory.ByteBufferWrapper;
import org.glassfish.grizzly.memory.slab.Slab;
import org.glassfish.grizzly.memory.slab.SlabMemoryManagerBase;

public class SlabByteBufferWrapper
extends ByteBufferWrapper {
    private Slab slab;
    private final int slabPosition;

    public SlabByteBufferWrapper(ByteBufferManager allocator, Slab slab, int size) {
        super(allocator, slab.allocate(size));
        this.slab = slab;
        this.slabPosition = slab.currentPosition();
    }

    @Override
    public void trim() {
        this.checkDispose();
        int sizeNeeded = this.visible.position();
        this.visible = this.slab.trim(this.slabPosition, this.visible, sizeNeeded);
        this.visible.position(0);
    }

    @Override
    public void dispose() {
        this.checkDispose();
        ((SlabMemoryManagerBase)this.memoryManager).dispose(this.slab, this.visible);
        super.dispose();
        this.slab = null;
    }

    private void checkDispose() {
        if (this.visible == null) {
            throw new IllegalStateException("BufferWrapper has already been disposed");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SlabByteBufferWrapper ");
        sb.append(", visible=[").append(this.visible).append(']');
        sb.append(']');
        return sb.toString();
    }
}

