/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.ByteBufferManager;

public class ByteBufferWrapper
implements Buffer<ByteBuffer> {
    public static boolean DEBUG_MODE = false;
    protected final ByteBufferManager memoryManager;
    protected ByteBuffer visible;
    private Exception disposeStackTrace;

    protected ByteBufferWrapper() {
        this(null, null);
    }

    public ByteBufferWrapper(ByteBufferManager memoryManager, ByteBuffer underlyingByteBuffer) {
        this.memoryManager = memoryManager;
        this.visible = underlyingByteBuffer;
    }

    @Override
    public ByteBuffer prepend(ByteBuffer header) {
        this.checkDispose();
        return this.visible;
    }

    @Override
    public void trim() {
        this.checkDispose();
        this.flip();
    }

    @Override
    public void dispose() {
        this.checkDispose();
        this.memoryManager.release(this);
        this.visible = null;
        if (DEBUG_MODE) {
            this.disposeStackTrace = new Exception("ByteBufferWrapper was disposed from: ");
        }
    }

    @Override
    public ByteBuffer underlying() {
        this.checkDispose();
        return this.visible;
    }

    @Override
    public int capacity() {
        return this.visible.capacity();
    }

    @Override
    public int position() {
        return this.visible.position();
    }

    public ByteBufferWrapper position(int newPosition) {
        this.visible.position(newPosition);
        return this;
    }

    @Override
    public int limit() {
        return this.visible.limit();
    }

    public ByteBufferWrapper limit(int newLimit) {
        this.visible.limit(newLimit);
        return this;
    }

    public ByteBufferWrapper mark() {
        this.visible.mark();
        return this;
    }

    public ByteBufferWrapper reset() {
        this.visible.reset();
        return this;
    }

    public ByteBufferWrapper clear() {
        this.visible.clear();
        return this;
    }

    public ByteBufferWrapper flip() {
        this.visible.flip();
        return this;
    }

    public ByteBufferWrapper rewind() {
        this.visible.rewind();
        return this;
    }

    @Override
    public int remaining() {
        return this.visible.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.visible.hasRemaining();
    }

    @Override
    public boolean isReadOnly() {
        return this.visible.isReadOnly();
    }

    public ByteBufferWrapper slice() {
        ByteBuffer slice = this.visible.slice();
        return this.memoryManager.wrap(slice);
    }

    public ByteBufferWrapper duplicate() {
        ByteBuffer duplicate = this.visible.duplicate();
        return this.memoryManager.wrap(duplicate);
    }

    public ByteBufferWrapper asReadOnlyBuffer() {
        this.visible.asReadOnlyBuffer();
        return this;
    }

    @Override
    public byte get() {
        return this.visible.get();
    }

    @Override
    public byte get(int index) {
        return this.visible.get(index);
    }

    public ByteBufferWrapper put(byte b) {
        this.visible.put(b);
        return this;
    }

    public ByteBufferWrapper put(int index, byte b) {
        this.visible.put(index, b);
        return this;
    }

    public ByteBufferWrapper get(byte[] dst) {
        this.visible.get(dst);
        return this;
    }

    public ByteBufferWrapper get(byte[] dst, int offset, int length) {
        this.visible.get(dst, offset, length);
        return this;
    }

    public ByteBufferWrapper put(Buffer src) {
        this.visible.put((ByteBuffer)src.underlying());
        return this;
    }

    public ByteBufferWrapper put(byte[] src) {
        this.visible.put(src);
        return this;
    }

    public ByteBufferWrapper put(byte[] src, int offset, int length) {
        this.visible.put(src, offset, length);
        return this;
    }

    public ByteBufferWrapper compact() {
        this.visible.compact();
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.visible.order();
    }

    public ByteBufferWrapper order(ByteOrder bo) {
        this.visible.order(bo);
        return this;
    }

    @Override
    public char getChar() {
        return this.visible.getChar();
    }

    @Override
    public char getChar(int index) {
        return this.visible.getChar(index);
    }

    public ByteBufferWrapper putChar(char value) {
        this.visible.putChar(value);
        return this;
    }

    public ByteBufferWrapper putChar(int index, char value) {
        this.visible.putChar(index, value);
        return this;
    }

    @Override
    public short getShort() {
        return this.visible.getShort();
    }

    @Override
    public short getShort(int index) {
        return this.visible.getShort(index);
    }

    public ByteBufferWrapper putShort(short value) {
        this.visible.putShort(value);
        return this;
    }

    public ByteBufferWrapper putShort(int index, short value) {
        this.visible.putShort(index, value);
        return this;
    }

    @Override
    public int getInt() {
        return this.visible.getInt();
    }

    @Override
    public int getInt(int index) {
        return this.visible.getInt(index);
    }

    public ByteBufferWrapper putInt(int value) {
        this.visible.putInt(value);
        return this;
    }

    public ByteBufferWrapper putInt(int index, int value) {
        this.visible.putInt(index, value);
        return this;
    }

    @Override
    public long getLong() {
        return this.visible.getLong();
    }

    @Override
    public long getLong(int index) {
        return this.visible.getLong(index);
    }

    public ByteBufferWrapper putLong(long value) {
        this.visible.putLong(value);
        return this;
    }

    public ByteBufferWrapper putLong(int index, long value) {
        this.visible.putLong(index, value);
        return this;
    }

    @Override
    public float getFloat() {
        return this.visible.getFloat();
    }

    @Override
    public float getFloat(int index) {
        return this.visible.getFloat(index);
    }

    public ByteBufferWrapper putFloat(float value) {
        this.visible.putFloat(value);
        return this;
    }

    public ByteBufferWrapper putFloat(int index, float value) {
        this.visible.putFloat(index, value);
        return this;
    }

    @Override
    public double getDouble() {
        return this.visible.getDouble();
    }

    @Override
    public double getDouble(int index) {
        return this.visible.getDouble(index);
    }

    public ByteBufferWrapper putDouble(double value) {
        this.visible.putDouble(value);
        return this;
    }

    public ByteBufferWrapper putDouble(int index, double value) {
        this.visible.putDouble(index, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBufferWrapper " + super.hashCode() + "[");
        sb.append("visible=[").append(this.visible).append(']');
        sb.append(']');
        return sb.toString();
    }

    public int hashCode() {
        return this.visible.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteBufferWrapper) {
            return this.visible.equals(((ByteBufferWrapper)obj).visible);
        }
        return false;
    }

    @Override
    public int compareTo(Buffer<ByteBuffer> o) {
        return this.visible.compareTo(o.underlying());
    }

    private void checkDispose() {
        if (this.visible == null) {
            throw new IllegalStateException("BufferWrapper has already been disposed", this.disposeStackTrace);
        }
    }

    @Override
    public String contentAsString(Charset charset) {
        this.checkDispose();
        String charsetName = charset.name();
        try {
            if (this.visible.hasArray()) {
                return new String(this.visible.array(), this.visible.position() + this.visible.arrayOffset(), this.visible.remaining(), charsetName);
            }
            int oldPosition = this.visible.position();
            byte[] tmpBuffer = new byte[this.visible.remaining()];
            this.visible.get(tmpBuffer);
            this.visible.position(oldPosition);
            return new String(tmpBuffer, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }
}

