/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.nio.ByteBuffer;
import org.glassfish.grizzly.memory.ByteBufferManager;
import org.glassfish.grizzly.memory.ByteBufferWrapper;

public class ByteBufferViewManager
extends ByteBufferManager {
    public static final int DEFAULT_CAPACITY = 524288;
    protected ByteBuffer largeByteBuffer;
    protected int capacity;

    public ByteBufferViewManager() {
        this(false);
    }

    public ByteBufferViewManager(boolean isDirect) {
        this(isDirect, 524288);
    }

    public ByteBufferViewManager(boolean isDirect, int capacity) {
        super(isDirect);
        this.capacity = capacity;
    }

    @Override
    public synchronized ByteBufferWrapper allocate(int size) {
        if (this.largeByteBuffer == null || this.largeByteBuffer.remaining() < size) {
            this.largeByteBuffer = this.allocate0(this.capacity);
        }
        return this.wrap(ByteBufferViewManager.slice(this.largeByteBuffer, size));
    }

    @Override
    public synchronized ByteBufferWrapper reallocate(ByteBufferWrapper oldBuffer, int newSize) {
        return super.reallocate(oldBuffer, newSize);
    }

    protected static ByteBuffer slice(ByteBuffer chunk, int size) {
        chunk.limit(chunk.position() + size);
        ByteBuffer view = chunk.slice();
        chunk.position(chunk.limit());
        chunk.limit(chunk.capacity());
        return view;
    }
}

