/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ReadyFutureImpl<R>
implements Future<R> {
    protected final R result;
    private final Throwable failure;
    private final boolean isCancelled;

    public ReadyFutureImpl() {
        this(null, null, true);
    }

    public ReadyFutureImpl(R result) {
        this(result, null, false);
    }

    public ReadyFutureImpl(Throwable failure) {
        this(null, failure, false);
    }

    protected ReadyFutureImpl(R result, Throwable failure, boolean isCancelled) {
        this.result = result;
        this.failure = failure;
        this.isCancelled = isCancelled;
    }

    public R getResult() {
        return this.result;
    }

    public void setResult(R result) {
        throw new IllegalStateException("Can not be reset on ReadyFutureImpl");
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.isCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.result;
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        if (this.result != null) {
            return this.result;
        }
        throw new TimeoutException();
    }

    public void failure(Throwable failure) {
        throw new IllegalStateException("Can not be reset on ReadyFutureImpl");
    }
}

