/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.glassfish.grizzly.filterchain.AbstractFilterChain;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainFactory;

public abstract class ListFacadeFilterChain
extends AbstractFilterChain {
    protected final List<Filter> filters;

    public ListFacadeFilterChain(FilterChainFactory factory, List<Filter> filtersImpl) {
        super(factory);
        this.filters = filtersImpl;
    }

    @Override
    public boolean add(Filter filter) {
        int size = this.filters.size();
        if (this.filters.add(filter)) {
            this.recalculateFilterIndexes(size);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, Filter filter) {
        this.filters.add(index, filter);
        this.recalculateFilterIndexes(index);
    }

    @Override
    public boolean addAll(Collection<? extends Filter> c) {
        int size = this.filters.size();
        if (this.filters.addAll(c)) {
            this.recalculateFilterIndexes(size);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Filter> c) {
        if (this.filters.addAll(index, c)) {
            this.recalculateFilterIndexes(index);
            return true;
        }
        return false;
    }

    @Override
    public Filter set(int index, Filter filter) {
        Filter prevFilter = this.filters.set(index, filter);
        if (filter.isIndexable()) {
            filter.setIndex(index);
        }
        return prevFilter;
    }

    @Override
    public Filter get(int index) {
        return this.filters.get(index);
    }

    @Override
    public int indexOf(Object object) {
        Filter filter = (Filter)object;
        if (filter.isIndexable()) {
            return filter.getIndex();
        }
        return this.filters.indexOf(filter);
    }

    @Override
    public int lastIndexOf(Object filter) {
        return this.filters.lastIndexOf(filter);
    }

    @Override
    public boolean contains(Object filter) {
        return this.filters.contains(filter);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.filters.containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.filters.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.filters.toArray(a);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.filters.retainAll(c)) {
            this.recalculateFilterIndexes(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        Filter filter = (Filter)object;
        if (filter.isIndexable()) {
            return this.remove(filter.getIndex()) != null;
        }
        if (this.filters.remove(filter)) {
            this.recalculateFilterIndexes(0);
            return true;
        }
        return false;
    }

    @Override
    public Filter remove(int index) {
        Filter removingFilter = this.filters.remove(index);
        if (removingFilter != null) {
            this.recalculateFilterIndexes(index);
            return removingFilter;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.filters.removeAll(c)) {
            this.recalculateFilterIndexes(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.filters == null || this.filters.isEmpty();
    }

    @Override
    public int size() {
        return this.filters.size();
    }

    @Override
    public void clear() {
        this.filters.clear();
    }

    @Override
    public Iterator<Filter> iterator() {
        return this.filters.iterator();
    }

    @Override
    public ListIterator<Filter> listIterator() {
        return this.filters.listIterator();
    }

    @Override
    public ListIterator<Filter> listIterator(int index) {
        return this.filters.listIterator(index);
    }

    @Override
    public List<Filter> subList(int fromIndex, int toIndex) {
        return this.filters.subList(fromIndex, toIndex);
    }

    protected void recalculateFilterIndexes(int startPosition) {
        for (int i = startPosition; i < this.filters.size(); ++i) {
            Filter filter = this.filters.get(i);
            if (!filter.isIndexable()) continue;
            filter.setIndex(i);
        }
    }
}

