/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Codec;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.filterchain.AbstractNextAction;
import org.glassfish.grizzly.filterchain.DefaultFilterChainCodec;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainFactory;
import org.glassfish.grizzly.filterchain.InvokeAction;
import org.glassfish.grizzly.filterchain.ListFacadeFilterChain;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.util.LightArrayList;

public class DefaultFilterChain
extends ListFacadeFilterChain {
    private static final FilterExecutor[] filterExecutors = new FilterExecutor[]{null, null, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.handleAccept(context, nextAction);
        }
    }, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.handleConnect(context, nextAction);
        }
    }, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.handleRead(context, nextAction);
        }
    }, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.handleWrite(context, nextAction);
        }
    }, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.handleClose(context, nextAction);
        }
    }};
    private static final FilterExecutor[] filterPostExecutors = new FilterExecutor[]{null, null, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.postAccept(context, nextAction);
        }
    }, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.postConnect(context, nextAction);
        }
    }, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.postRead(context, nextAction);
        }
    }, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.postWrite(context, nextAction);
        }
    }, new FilterExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context, NextAction nextAction) throws IOException {
            return filter.postClose(context, nextAction);
        }
    }};
    private static final boolean[] isContinueExecution = new boolean[]{true, false, false, true};
    private Logger logger = Grizzly.logger;
    private final DefaultFilterChainCodec filterChainCodec = new DefaultFilterChainCodec(this);

    public DefaultFilterChain(FilterChainFactory factory) {
        super(factory, new LightArrayList<Filter>());
    }

    @Override
    public ProcessorResult execute(FilterChainContext ctx) {
        try {
            int ioEventIndex = ctx.getIoEvent().ordinal();
            if (!this.executeChain(ctx, filterExecutors[ioEventIndex]) || !this.postExecuteChain(ctx, filterPostExecutors[ioEventIndex])) {
                return new ProcessorResult(ProcessorResult.Status.TERMINATE);
            }
        }
        catch (IOException e) {
            try {
                this.logger.log(Level.FINE, "Exception during FilterChain execution", e);
                this.throwChain(ctx, e);
                ctx.getConnection().close();
            }
            catch (IOException ioe) {}
        }
        catch (Exception e) {
            try {
                this.logger.log(Level.WARNING, "Exception during FilterChain execution", e);
                this.throwChain(ctx, e);
                ctx.getConnection().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean executeChain(FilterChainContext ctx, FilterExecutor executor) throws Exception {
        NextAction nextAction;
        List<Filter> chain = ctx.getFilters();
        int currentFilterIdx = ctx.getCurrentFilterIdx();
        if (chain == null) {
            ctx.setFilters(this.filters);
            ctx.setCurrentFilterIdx(0);
            chain = this.filters;
            currentFilterIdx = 0;
            nextAction = this.getCachedInvokeAction(ctx);
        } else {
            nextAction = new InvokeAction(chain);
        }
        while (currentFilterIdx < chain.size()) {
            ((AbstractNextAction)nextAction).setNextFilterIdx(currentFilterIdx + 1);
            Filter currentFilter = (Filter)chain.get(currentFilterIdx);
            ctx.setCurrentFilter(currentFilter);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.fine("Execute filter. filter=" + currentFilter + " context=" + ctx);
            }
            nextAction = executor.execute(currentFilter, ctx, nextAction);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.fine("after execute filter. filter=" + currentFilter + " context=" + ctx + " nextAction=" + nextAction);
            }
            ctx.getExecutedFilters().add(currentFilter);
            if (!isContinueExecution[nextAction.type()]) {
                return nextAction.type() != 2;
            }
            chain = nextAction.getFilters();
            currentFilterIdx = nextAction.getNextFilterIdx();
            ctx.setFilters(chain);
            ctx.setCurrentFilterIdx(currentFilterIdx);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean postExecuteChain(FilterChainContext ctx, FilterExecutor executor) throws Exception {
        List<Filter> chain = ctx.getExecutedFilters();
        int offset = chain.size() - 1;
        if (offset < 0) {
            return true;
        }
        NextAction nextAction = new InvokeAction(chain);
        for (int i = chain.size() - 1; i >= 0; --i) {
            Filter currentFilter = chain.get(i);
            ctx.setCurrentFilter(currentFilter);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.fine("PostExecute filter. filter=" + currentFilter + " context=" + ctx);
            }
            nextAction = executor.execute(currentFilter, ctx, nextAction);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.fine("after PostExecute filter. filter=" + currentFilter + " context=" + ctx + " nextAction=" + nextAction);
            }
            if (nextAction.type() != 3) continue;
            List<Filter> tmpExecutedFilters = chain;
            List<Filter> tmpNextFilters = ctx.getFilters();
            int tmpCurrentFilterIdx = ctx.getCurrentFilterIdx();
            ctx.setExecutedFilters(new LightArrayList<Filter>());
            ctx.setFilters(chain);
            ctx.setCurrentFilterIdx(0);
            try {
                this.execute(ctx);
                continue;
            }
            finally {
                ctx.setExecutedFilters(tmpExecutedFilters);
                ctx.setFilters(tmpNextFilters);
                ctx.setCurrentFilterIdx(tmpCurrentFilterIdx);
            }
        }
        return true;
    }

    protected void throwChain(FilterChainContext ctx, Throwable exception) {
        List<Filter> chain = ctx.getExecutedFilters();
        if (chain.size() <= 0) {
            return;
        }
        List<Filter> executedFilters = ctx.getExecutedFilters();
        for (Filter filter : executedFilters) {
            ctx.setCurrentFilter(filter);
            filter.exceptionOccurred(ctx, exception);
        }
    }

    @Override
    public Codec getCodec() {
        return this.filterChainCodec;
    }

    private NextAction getCachedInvokeAction(FilterChainContext ctx) {
        InvokeAction cachedInvokeAction = ctx.getCachedInvokeAction();
        if (cachedInvokeAction == null || cachedInvokeAction.filters != this.filters) {
            cachedInvokeAction = new InvokeAction(this.filters);
            ctx.setCachedInvokeAction(cachedInvokeAction);
        }
        return cachedInvokeAction;
    }

    public static interface FilterExecutor {
        public NextAction execute(Filter var1, FilterChainContext var2, NextAction var3) throws IOException;
    }
}

