/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import java.util.HashSet;
import java.util.Set;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.DefaultAttributeBuilder;
import org.glassfish.grizzly.attributes.IndexedAttributeAccessor;
import org.glassfish.grizzly.util.LightArrayList;

public class IndexedAttributeHolder
implements AttributeHolder {
    protected LightArrayList<Object> attributeValues;
    protected DefaultAttributeBuilder attributeBuilder;
    protected IndexedAttributeAccessor indexedAttributeAccessor;

    public IndexedAttributeHolder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = (DefaultAttributeBuilder)attributeBuilder;
        this.attributeValues = new LightArrayList();
        this.indexedAttributeAccessor = new IndexedAttributeAccessorImpl();
    }

    @Override
    public Object getAttribute(String name) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            return this.indexedAttributeAccessor.getAttribute(attribute.index());
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute == null) {
            attribute = this.attributeBuilder.createAttribute(name);
        }
        this.indexedAttributeAccessor.setAttribute(attribute.index(), value);
    }

    @Override
    public Object removeAttribute(String name) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            int index = attribute.index();
            Object value = this.indexedAttributeAccessor.getAttribute(index);
            if (value != null) {
                this.indexedAttributeAccessor.setAttribute(index, null);
            }
            return value;
        }
        return null;
    }

    @Override
    public Set<String> getAttributeNames() {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this.attributeValues.size(); ++i) {
            Object value = this.attributeValues.get(i);
            if (value == null) continue;
            Attribute attribute = this.attributeBuilder.getAttributeByIndex(i);
            result.add(attribute.name());
        }
        return result;
    }

    @Override
    public void clear() {
        this.attributeValues.clear();
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public IndexedAttributeAccessor getIndexedAttributeAccessor() {
        return this.indexedAttributeAccessor;
    }

    protected class IndexedAttributeAccessorImpl
    implements IndexedAttributeAccessor {
        protected IndexedAttributeAccessorImpl() {
        }

        @Override
        public Object getAttribute(int index) {
            if (index >= IndexedAttributeHolder.this.attributeValues.size()) {
                return null;
            }
            return IndexedAttributeHolder.this.attributeValues.get(index);
        }

        @Override
        public void setAttribute(int index, Object value) {
            int attrCount = IndexedAttributeHolder.this.attributeValues.size();
            if (attrCount <= index) {
                int fakeElementsToAdd = index - attrCount;
                IndexedAttributeHolder.this.attributeValues.size(index + 1);
                for (int i = 0; i < fakeElementsToAdd; ++i) {
                    IndexedAttributeHolder.this.attributeValues.set(attrCount + i, null);
                }
            }
            IndexedAttributeHolder.this.attributeValues.set(index, value);
        }
    }
}

