/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.memory.DefaultMemoryManager;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.nio.DefaultNIOTransportFactory;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.UDPNIOTransport;
import org.glassfish.grizzly.threadpool.DefaultScheduleThreadPool;
import org.glassfish.grizzly.threadpool.DefaultThreadPool;

public abstract class TransportFactory {
    private static volatile TransportFactory instance;
    private boolean isClosed;
    protected AttributeBuilder defaultAttributeBuilder;
    protected MemoryManager defaultMemoryManager;
    protected ExecutorService defaultWorkerThreadPool;
    protected ScheduledExecutorService defaultScheduledThreadPool;

    public static synchronized TransportFactory getInstance() {
        if (instance == null || instance.isClosed()) {
            instance = new DefaultNIOTransportFactory();
        }
        return instance;
    }

    public static synchronized void setInstance(TransportFactory factory) {
        instance = factory;
    }

    public abstract TCPNIOTransport createTCPTransport();

    public abstract UDPNIOTransport createUDPTransport();

    protected TransportFactory() {
        this.initialize();
    }

    public AttributeBuilder getDefaultAttributeBuilder() {
        return this.defaultAttributeBuilder;
    }

    public void setDefaultAttributeBuilder(AttributeBuilder defaultAttributeBuilder) {
        this.defaultAttributeBuilder = defaultAttributeBuilder;
    }

    public MemoryManager getDefaultMemoryManager() {
        return this.defaultMemoryManager;
    }

    public void setDefaultMemoryManager(MemoryManager defaultMemoryManager) {
        this.defaultMemoryManager = defaultMemoryManager;
    }

    public ExecutorService getDefaultWorkerThreadPool() {
        return this.defaultWorkerThreadPool;
    }

    public void setDefaultWorkerThreadPool(ExecutorService defaultThreadPool) {
        this.defaultWorkerThreadPool = defaultThreadPool;
    }

    public ScheduledExecutorService getDefaultScheduledThreadPool() {
        return this.defaultScheduledThreadPool;
    }

    public void setDefaultScheduledThreadPool(ScheduledExecutorService defaultScheduledThreadPool) {
        this.defaultScheduledThreadPool = defaultScheduledThreadPool;
    }

    public void initialize() {
        this.defaultAttributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
        this.defaultMemoryManager = new DefaultMemoryManager();
        this.defaultWorkerThreadPool = new DefaultThreadPool();
        this.defaultScheduledThreadPool = new DefaultScheduleThreadPool();
    }

    public synchronized void close() {
        if (!this.isClosed()) {
            this.isClosed = true;
            if (this.defaultWorkerThreadPool != null) {
                this.defaultWorkerThreadPool.shutdown();
                this.defaultWorkerThreadPool = null;
            }
            if (this.defaultScheduledThreadPool != null) {
                this.defaultScheduledThreadPool.shutdown();
                this.defaultScheduledThreadPool = null;
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected <T extends Transport> T setupTransport(T transport) {
        transport.setAttributeBuilder(this.defaultAttributeBuilder);
        transport.setMemoryManager(this.defaultMemoryManager);
        transport.setWorkerThreadPool(this.defaultWorkerThreadPool);
        return transport;
    }
}

