/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

public class TransformationResult<T> {
    private T message;
    private Status status;
    private int errorCode;
    private String errorDescription;

    public TransformationResult() {
        this(Status.COMPLETED);
    }

    public TransformationResult(Status status) {
        this(status, null);
    }

    public TransformationResult(Status status, T message) {
        this.status = status;
        this.message = message;
    }

    public TransformationResult(int errorCode, String errorDescription) {
        this.status = Status.ERROR;
        this.errorCode = errorCode;
        this.errorDescription = errorDescription;
    }

    public T getMessage() {
        return this.message;
    }

    public void setMessage(T message) {
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Transformation result. Status: ").append((Object)this.status);
        sb.append(" message: ").append(this.message);
        if (this.status == Status.ERROR) {
            sb.append(" errorCode: ").append(this.errorCode);
            sb.append(" errorDescription: ").append(this.errorDescription);
        }
        return sb.toString();
    }

    public static enum Status {
        COMPLETED,
        INCOMPLED,
        ERROR;

    }
}

