/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.memory.MemoryManager;

public abstract class AbstractTransformer<K, L>
implements Transformer<K, L> {
    protected static TransformationResult incompletedResult = new TransformationResult(TransformationResult.Status.INCOMPLED);
    protected AttributeBuilder attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
    protected Attribute<K> inputBufferAttribute;
    protected Attribute<L> outputBufferAttribute;
    protected Attribute<TransformationResult<L>> lastResultAttribute;
    private MemoryManager memoryManager;

    public AbstractTransformer() {
        String namePrefix = this.getClass().getName();
        this.inputBufferAttribute = this.attributeBuilder.createAttribute(namePrefix + ".inputBuffer");
        this.outputBufferAttribute = this.attributeBuilder.createAttribute(namePrefix + ".outputBuffer");
        this.lastResultAttribute = this.attributeBuilder.createAttribute(namePrefix + ".lastResult");
    }

    @Override
    public TransformationResult<L> transform(AttributeStorage storage) throws TransformationException {
        return this.transform(storage, this.getInput(storage), this.getOutput(storage));
    }

    @Override
    public K getInput(AttributeStorage storage) {
        return AbstractTransformer.getValue(storage, this.inputBufferAttribute);
    }

    @Override
    public void setInput(AttributeStorage storage, K input) {
        this.inputBufferAttribute.set(storage.obtainAttributes(), input);
    }

    @Override
    public L getOutput(AttributeStorage storage) {
        return AbstractTransformer.getValue(storage, this.outputBufferAttribute);
    }

    @Override
    public void setOutput(AttributeStorage storage, L output) {
        this.outputBufferAttribute.set(storage.obtainAttributes(), output);
    }

    @Override
    public TransformationResult<L> getLastResult(AttributeStorage storage) {
        return AbstractTransformer.getValue(storage, this.lastResultAttribute);
    }

    @Override
    public AttributeHolder getProperties(AttributeStorage storage) {
        return storage.getAttributes();
    }

    @Override
    public void hibernate(AttributeStorage storage) {
    }

    @Override
    public void release(AttributeStorage storage) {
        AbstractTransformer.removeValue(storage, this.inputBufferAttribute);
        AbstractTransformer.removeValue(storage, this.outputBufferAttribute);
        AbstractTransformer.removeValue(storage, this.lastResultAttribute);
    }

    protected static <E> E getValue(AttributeStorage storage, Attribute<E> attribute) {
        return AbstractTransformer.getValue(storage, attribute, null);
    }

    protected static <E> E getValue(AttributeStorage storage, Attribute<E> attribute, E defaultValue) {
        E value;
        AttributeHolder holder = storage.getAttributes();
        if (holder != null && (value = attribute.get(holder)) != null) {
            return value;
        }
        return defaultValue;
    }

    protected static <E> void setValue(AttributeStorage storage, Attribute<E> attribute, E value) {
        AttributeHolder holder = storage.obtainAttributes();
        attribute.set(holder, value);
    }

    protected static <E> E removeValue(AttributeStorage storage, Attribute<E> attribute) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return attribute.remove(holder);
        }
        return null;
    }

    protected MemoryManager obtainMemoryManager(AttributeStorage storage) {
        if (this.memoryManager != null) {
            return this.memoryManager;
        }
        if (storage instanceof Connection) {
            Connection connection = (Connection)storage;
            return connection.getTransport().getMemoryManager();
        }
        return null;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }
}

