/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.external.probe.provider;

import java.util.Vector;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManagerDelegate;

public class StatsProviderManager {
    static StatsProviderManagerDelegate spmd;
    static Vector<StatsProviderRegistryElement> toBeRegistered;

    private StatsProviderManager() {
    }

    public static synchronized boolean register(String configElement, PluginPoint pp, String subTreeRoot, Object statsProvider) {
        if (spmd != null) {
            spmd.register(configElement, pp, subTreeRoot, statsProvider);
            return true;
        }
        toBeRegistered.add(new StatsProviderRegistryElement(configElement, pp, subTreeRoot, statsProvider));
        return false;
    }

    public static synchronized boolean unregister(Object statsProvider) {
        if (spmd == null) {
            for (StatsProviderRegistryElement spre : toBeRegistered) {
                if (spre.getStatsProvider() != statsProvider) continue;
                toBeRegistered.remove(spre);
                break;
            }
        } else {
            spmd.unregister(statsProvider);
            return true;
        }
        return false;
    }

    public static synchronized boolean hasListeners(String probeStr) {
        if (spmd == null) {
            return false;
        }
        return spmd.hasListeners(probeStr);
    }

    public static synchronized void setStatsProviderManagerDelegate(StatsProviderManagerDelegate lspmd) {
        if (lspmd == null) {
            return;
        }
        spmd = lspmd;
        for (StatsProviderRegistryElement spre : toBeRegistered) {
            spmd.register(spre.configElement, spre.pp, spre.subTreeRoot, spre.statsProvider);
        }
        toBeRegistered.clear();
    }

    static {
        toBeRegistered = new Vector();
    }

    private static class StatsProviderRegistryElement {
        String configElement;
        PluginPoint pp;
        String subTreeRoot;
        Object statsProvider;

        public StatsProviderRegistryElement(String configElement, PluginPoint pp, String subTreeRoot, Object statsProvider) {
            this.configElement = configElement;
            this.pp = pp;
            this.subTreeRoot = subTreeRoot;
            this.statsProvider = statsProvider;
        }

        public Object getStatsProvider() {
            return this.statsProvider;
        }
    }
}

