/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.common.util.logging.LoggingOutputStream;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.server.logging.UniformLogFormatter;
import com.sun.enterprise.v3.logging.AgentFormatterDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.api.branding.Branding;
import org.glassfish.internal.api.Init;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class LogManagerService
implements Init,
PostConstruct,
PreDestroy {
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Habitat habitat;
    @Inject(optional=true)
    Agent agent = null;
    @Inject
    FileMonitoring fileMonitoring;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        Collection handlers;
        UniformLogFormatter.branding = (Branding)this.habitat.getByContract(Branding.class);
        if (System.getProperty("java.util.logging.config.file") != null) {
            return;
        }
        final LogManager logMgr = LogManager.getLogManager();
        final File logging = new File(this.env.getConfigDirPath(), "logging.properties");
        System.setProperty("java.util.logging.config.file", logging.getAbsolutePath());
        try {
            logMgr.readConfiguration();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Cannot read logging configuration file : ", e);
        }
        AgentFormatterDelegate agentDelegate = null;
        if (this.agent != null) {
            agentDelegate = new AgentFormatterDelegate(this.agent);
        }
        if ((handlers = this.habitat.getAllByContract(Handler.class)) != null && handlers.size() > 0) {
            LogManager logManager = logMgr;
            synchronized (logManager) {
                Enumeration<String> loggerNames = logMgr.getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    String loggerName = loggerNames.nextElement();
                    logMgr.getLogger(loggerName);
                    for (Handler handler : this.logger.getHandlers()) {
                        if (!(handler.getFormatter() instanceof UniformLogFormatter)) continue;
                        ((UniformLogFormatter)handler.getFormatter()).setDelegate(agentDelegate);
                    }
                }
                for (Handler handler : handlers) {
                    Logger rootLogger = Logger.global.getParent();
                    if (rootLogger == null) continue;
                    rootLogger.addHandler(handler);
                }
            }
        }
        LoggingOutputStream los = new LoggingOutputStream(Logger.getAnonymousLogger(), Level.INFO);
        PrintStream pout = new PrintStream((OutputStream)los, true);
        System.setOut(pout);
        los = new LoggingOutputStream(Logger.getAnonymousLogger(), Level.SEVERE);
        PrintStream perr = new PrintStream((OutputStream)los, true);
        System.setErr(perr);
        if (logging != null) {
            this.fileMonitoring.monitors(logging, new FileMonitoring.FileChangeListener(){

                public void changed(File changedFile) {
                    try {
                        Properties props = new Properties();
                        FileInputStream fis = new FileInputStream(new File(logging.getAbsolutePath()));
                        props.load(fis);
                        Enumeration<String> loggerNames = logMgr.getLoggerNames();
                        while (loggerNames.hasMoreElements()) {
                            String loggerName = loggerNames.nextElement();
                            String level = props.getProperty(loggerName + ".level");
                            if (level == null) continue;
                            Level l = Level.parse(level);
                            logMgr.getLogger(loggerName).setLevel(l);
                            if (loggerName.equals("")) {
                                loggerName = "rootLogger";
                            }
                            LogManagerService.this.logger.log(Level.INFO, "Updated level for " + loggerName + " to " + logMgr.getLogger(loggerName).getLevel().toString());
                        }
                        fis.close();
                    }
                    catch (IOException e) {
                        LogManagerService.this.logger.log(Level.SEVERE, "Cannot read logging.properties file : ", e);
                    }
                }
            });
        }
    }

    public void preDestroy() {
        try {
            for (Inhabitant i : this.habitat.getInhabitants(Handler.class)) {
                i.release();
            }
        }
        catch (ComponentException e) {
            e.printStackTrace();
        }
    }
}

