/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.HTMLActionReporter;
import com.sun.enterprise.v3.server.ApplicationLifecycle;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Startup;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ContainerInfo;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLoaderService
extends ApplicationLifecycle
implements Startup,
PreDestroy,
PostConstruct {
    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        assert (this.env != null);
        block7: for (Module m : this.applications.getModules()) {
            if (!(m instanceof Application)) continue;
            Application module = (Application)m;
            for (ApplicationRef appRef : this.server.getApplicationRef()) {
                if (!appRef.getRef().equals(module.getName())) continue;
                if (!appRef.getEnabled().equals(String.valueOf(Boolean.TRUE))) continue block7;
                this.processApplication(module, appRef, this.logger);
                continue block7;
            }
        }
        String defaultParam = this.env.getStartupContext().getArguments().getProperty("default");
        if (defaultParam != null) {
            File sourceFile = defaultParam.equals(".") ? new File(System.getProperty("user.dir")) : new File(defaultParam);
            Properties deploymentProperties = new Properties();
            deploymentProperties.setProperty("name", sourceFile.getName());
            if (sourceFile.exists()) {
                if (!(sourceFile = sourceFile.getAbsoluteFile()).isDirectory()) {
                    deploymentProperties.setProperty("name", sourceFile.getName());
                    Events events = (Events)this.habitat.getComponent(Events.class);
                    try {
                        final File tmpFile = File.createTempFile(sourceFile.getName(), "");
                        String path = tmpFile.getAbsolutePath();
                        tmpFile.delete();
                        File tmpDir = new File(path);
                        tmpDir.deleteOnExit();
                        events.register(new EventListener(){

                            public void event(EventListener.Event event) {
                                if (event.is(EventTypes.SERVER_SHUTDOWN) && tmpFile.exists()) {
                                    FileUtils.whack((File)tmpFile);
                                }
                            }
                        });
                        if (tmpDir.mkdirs()) {
                            ReadableArchive sourceArchive = null;
                            sourceArchive = this.archiveFactory.openArchive(sourceFile);
                            ArchiveHandler handler = this.getArchiveHandler(sourceArchive);
                            String appName = handler.getDefaultApplicationName(sourceArchive);
                            deploymentProperties.setProperty("name", appName);
                            deploymentProperties.setProperty("contextroot", appName);
                            handler.expand(sourceArchive, this.archiveFactory.createArchive(tmpDir));
                            sourceFile = tmpDir;
                            this.logger.info("Source is not a directory, using temporary location " + tmpDir.getAbsolutePath());
                            this.logger.warning("Using " + appName + " as context root for application");
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    ReadableArchive sourceArchive = null;
                    try {
                        sourceArchive = this.archiveFactory.openArchive(sourceFile);
                        ArchiveHandler handler = this.getArchiveHandler(sourceArchive);
                        deploymentProperties.setProperty("name", sourceFile.getName());
                        deploymentProperties.setProperty("enabled", "True");
                        DeploymentContextImpl depContext = new DeploymentContextImpl(this.logger, sourceArchive, deploymentProperties, this.env);
                        depContext.setPhase(DeploymentContextImpl.Phase.PREPARE);
                        depContext.createClassLoaders(this.clh, handler);
                        Collection<Sniffer> appSniffers = this.snifferManager.getSniffers(sourceArchive, depContext.getClassLoader());
                        if (appSniffers != null) {
                            HTMLActionReporter report = new HTMLActionReporter();
                            this.deploy(appSniffers, depContext, report);
                        } else {
                            this.logger.severe("Cannot find the application type for the artifact at : " + sourceFile.getAbsolutePath());
                            this.logger.severe("Was the container or sniffer removed ?");
                        }
                    }
                    finally {
                        if (sourceArchive != null) {
                            sourceArchive.close();
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "IOException while opening deployed artifact", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processApplication(Application app, ApplicationRef appRef, Logger logger) {
        long operationStartTime = Calendar.getInstance().getTimeInMillis();
        String source = app.getLocation();
        String appName = app.getName();
        ArrayList<String> snifferTypes = new ArrayList<String>();
        for (Engine engine : app.getEngine()) {
            snifferTypes.add(engine.getSniffer());
        }
        if (snifferTypes.isEmpty()) {
            logger.severe("Cannot determine application type at " + source);
            return;
        }
        URI uri = null;
        try {
            uri = new URI(source);
        }
        catch (URISyntaxException e) {
            logger.severe("Cannot determine original location for application : " + e.getMessage());
            return;
        }
        File sourceFile = new File(uri);
        if (sourceFile.exists()) {
            try {
                ReadableArchive archive = null;
                try {
                    archive = this.archiveFactory.openArchive(sourceFile);
                    Properties deploymentParams = this.populateDeployParamsFromDomainXML(app, appRef);
                    DeploymentContextImpl depContext = new DeploymentContextImpl(logger, archive, deploymentParams, this.env);
                    depContext.setProps(this.populateDeployPropsFromDomainXML(app));
                    HTMLActionReporter report = new HTMLActionReporter();
                    ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
                    for (String snifferType : snifferTypes) {
                        Sniffer sniffer = this.snifferManager.getSniffer(snifferType);
                        if (sniffer != null) {
                            sniffers.add(sniffer);
                            continue;
                        }
                        logger.severe("Cannot find sniffer for module type : " + snifferType);
                    }
                    if (sniffers.isEmpty()) {
                        logger.severe("Cannot find any sniffer for deployed app " + appName);
                        return;
                    }
                    this.deploy(sniffers, depContext, report);
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        logger.info("Loading " + appName + " Application done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                    } else {
                        logger.severe(report.getMessage());
                    }
                }
                finally {
                    if (archive != null) {
                        try {
                            archive.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.FINE, e.getMessage(), e);
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "IOException while opening deployed artifact", e);
            }
        } else {
            logger.severe("Application previously deployed is not at its original location any more : " + source);
        }
    }

    protected <T extends Container, U extends ApplicationContainer> Deployer getDeployer(ContainerInfo<T, U> containerInfo) {
        final Deployer deployer = containerInfo.getDeployer();
        assert (deployer != null);
        return new Deployer<T, U>(){

            public <V> V loadMetaData(Class<V> type, DeploymentContext context) {
                return (V)deployer.loadMetaData(type, context);
            }

            public boolean prepare(DeploymentContext context) {
                return true;
            }

            public U load(T container, DeploymentContext context) {
                return deployer.load(container, context);
            }

            public void unload(U appContainer, DeploymentContext context) {
                deployer.unload(appContainer, context);
            }

            public void clean(DeploymentContext context) {
            }

            public MetaData getMetaData() {
                return deployer.getMetaData();
            }
        };
    }

    public String toString() {
        return "Application Loader";
    }

    public void preDestroy() {
        Properties props = new Properties();
        HTMLActionReporter dummy = new HTMLActionReporter();
        for (ContainerInfo containerInfo : this.containerRegistry.getContainers()) {
            Deployer deployer = this.getDeployer(containerInfo);
            if (deployer == null) continue;
            Iterable apps = containerInfo.getApplications();
            for (ApplicationInfo appInfo : apps) {
                props.put("name", appInfo.getName());
                DeploymentContextImpl depContext = new DeploymentContextImpl(this.logger, appInfo.getSource(), props, this.env);
                super.unload(appInfo.getName(), (DeploymentContext)depContext, dummy);
            }
            this.stopContainer(this.logger, containerInfo);
        }
    }
}

