/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.v3.common.ActionReporter;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.api.ActionReport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLActionReporter
extends ActionReporter {
    public void writeReport(OutputStream os) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.newDocument();
            d.appendChild(this.writeActionReport(d, this));
            this.writeXML(d, os);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Element writeActionReport(Document owningDocument, ActionReporter report) {
        Element result = owningDocument.createElement("action-report");
        result.setAttribute("description", report.actionDescription);
        result.setAttribute("exit-code", report.getActionExitCode().name());
        if (this.exception != null) {
            result.setAttribute("failure-cause", this.exception.getLocalizedMessage());
        }
        this.writePart(result, report.getTopMessagePart(), null);
        for (ActionReporter subReport : report.subActions) {
            result.appendChild(this.writeActionReport(owningDocument, subReport));
        }
        return result;
    }

    public String getContentType() {
        return "text/xml";
    }

    private void writePart(Element actionReport, ActionReport.MessagePart part, String childType) {
        Document d = actionReport.getOwnerDocument();
        Element messagePart = d.createElement("message-part");
        actionReport.appendChild(messagePart);
        if (childType != null) {
            messagePart.setAttribute("type", childType);
        }
        for (Map.Entry<Object, Object> prop : part.getProps().entrySet()) {
            Element p = d.createElement("property");
            messagePart.appendChild(p);
            p.setAttribute("name", prop.getKey().toString());
            p.setAttribute("value", prop.getValue().toString());
        }
        for (ActionReport.MessagePart subPart : part.getChildren()) {
            this.writePart(messagePart, subPart, subPart.getChildrenType());
        }
    }

    private void writeXML(Document doc, OutputStream os) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(os);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
    }
}

