/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.nexus.client.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.glassfish.nexus.client.logging.CustomPrinter;

public class CustomHandler
extends Handler {
    private CustomPrinter printer = null;

    public CustomHandler() {
        this.setFormatter(new SimpleFormatter(){

            public synchronized String format(LogRecord record) {
                return this.formatMessage(record);
            }
        });
    }

    public void setPrinter(CustomPrinter p) {
        this.printer = p;
    }

    public CustomHandler(CustomPrinter p) {
        this();
        this.printer = p;
    }

    public void publish(LogRecord record) {
        if (this.printer == null || !this.isLoggable(record)) {
            return;
        }
        String msg = this.getFormatter().format(record);
        BufferedReader br = new BufferedReader(new StringReader(msg));
        try {
            if (record.getLevel().equals(Level.INFO)) {
                String line;
                while ((line = br.readLine()) != null) {
                    this.printer.info(line);
                }
            } else if (record.getLevel().equals(Level.WARNING)) {
                String line;
                while ((line = br.readLine()) != null) {
                    this.printer.warning(line);
                }
            } else if (record.getLevel().equals(Level.SEVERE)) {
                String line;
                while ((line = br.readLine()) != null) {
                    this.printer.error(line);
                }
            } else {
                String line;
                while ((line = br.readLine()) != null) {
                    this.printer.debug(line);
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

