/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.nexus.client;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.glassfish.nexus.client.NexusClientException;
import org.glassfish.nexus.client.NexusClientImpl;
import org.glassfish.nexus.client.StagingOperation;
import org.glassfish.nexus.client.beans.Repo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingAggregation
implements StagingOperation {
    private Set<StagingOperation> repos = new HashSet<StagingOperation>();

    public StagingAggregation() {
    }

    public StagingAggregation(Repo repo) {
        this();
        if (repo != null) {
            this.repos.add(repo);
        }
    }

    private NexusClientImpl getNexusClient() {
        return (NexusClientImpl)NexusClientImpl.getInstance();
    }

    public StagingAggregation(Collection<Repo> repos) {
        this();
        repos.addAll(repos);
    }

    @Override
    public void close(String msg) throws NexusClientException {
        this.getNexusClient().closeStagingRepo(msg, this.getIds());
    }

    @Override
    public void drop(String msg) throws NexusClientException {
        this.getNexusClient().dropStagingRepo(msg, this.getIds());
    }

    @Override
    public Repo promote(String profile, String msg) throws NexusClientException {
        String[] ids = this.getIds();
        if (ids != null && ids.length > 0) {
            return this.getNexusClient().promoteStagingRepo(profile, msg, this.getIds());
        }
        return null;
    }

    @Override
    public StagingAggregation aggregate(StagingOperation repo) throws NexusClientException {
        this.repos.add(repo);
        return this;
    }

    @Override
    public String[] getIds() {
        String[] repoIds = null;
        if (!this.repos.isEmpty()) {
            repoIds = new String[this.repos.size()];
            Iterator<StagingOperation> it = this.repos.iterator();
            int i = 0;
            while (it.hasNext()) {
                repoIds[i] = it.next().getIds()[0];
                ++i;
            }
        }
        return repoIds;
    }

    @Override
    public void close(String msg, int retryCount, long timeout) throws NexusClientException {
        this.getNexusClient().closeStagingRepo(msg, this.getIds(), retryCount, timeout);
    }

    @Override
    public void drop(String msg, int retryCount, long timeout) throws NexusClientException {
        this.getNexusClient().dropStagingRepo(msg, this.getIds(), retryCount, timeout);
    }

    @Override
    public Repo promote(String profile, String msg, int retryCount, long timeout) throws NexusClientException {
        String[] ids = this.getIds();
        if (ids != null && ids.length > 0) {
            return this.getNexusClient().promoteStagingRepo(profile, msg, this.getIds(), retryCount, timeout);
        }
        return null;
    }
}

