/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.nexus.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientFactory;
import javax.ws.rs.core.Configurable;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnector;
import org.glassfish.jersey.client.SslConfig;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.moxy.json.MoxyJsonFeature;
import org.glassfish.nexus.client.JsonMoxyConfigurationContextResolver;
import org.glassfish.nexus.client.logging.CustomHandler;
import org.glassfish.nexus.client.logging.CustomPrinter;

public class RestClient {
    private Client client;
    private boolean useSsl = false;
    private String proxyHost;
    private int proxyPort;
    private char[] username;
    private char[] password;
    private CustomHandler handler = null;

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getUsername() {
        return new String(this.username);
    }

    public Client getClient() {
        return this.client;
    }

    private void initClient() {
        ClientConfig cc = new ClientConfig();
        if (this.proxyHost != null && !this.proxyHost.isEmpty()) {
            cc.connector((Connector)new HttpUrlConnector(new HttpUrlConnector.ConnectionFactory(){

                public HttpURLConnection getConnection(URL url) throws IOException {
                    InetSocketAddress inetAddr = new InetSocketAddress(InetAddress.getByName(RestClient.this.proxyHost), RestClient.this.proxyPort);
                    return (HttpURLConnection)url.openConnection(new Proxy(Proxy.Type.HTTP, inetAddr));
                }
            }));
        }
        if (this.useSsl) {
            SSLContext context = null;
            try {
                context = SSLContext.getInstance("SSL");
                context.init(null, null, null);
            }
            catch (NoSuchAlgorithmException ex) {
            }
            catch (KeyManagementException keyManagementException) {
                // empty catch block
            }
            cc.setProperty("jersey.config.client.ssl.sslConfig", (Object)new SslConfig(context));
        }
        if (this.username != null && this.username.length > 0 && this.password != null && this.password.length > 0) {
            HttpBasicAuthFilter authFilter = new HttpBasicAuthFilter(new String(this.username), new String(this.password));
            cc.register((Object)authFilter);
        }
        cc.register((Object)new MoxyJsonFeature()).register((Object)new JsonMoxyConfigurationContextResolver());
        Logger logger = Logger.getLogger(RestClient.class.getSimpleName());
        logger.setLevel(Level.ALL);
        if (this.handler != null) {
            logger.setUseParentHandlers(false);
            logger.addHandler(this.handler);
        }
        cc.register((Object)new LoggingFilter(logger, true));
        this.client = ClientFactory.newClient((Configurable)cc);
    }

    public RestClient() {
        this.initClient();
    }

    public RestClient(CustomHandler handler) {
        this.handler = handler;
        this.initClient();
    }

    public RestClient(boolean useSsl) {
        this.useSsl = useSsl;
        this.initClient();
    }

    public RestClient(boolean useSsl, CustomHandler handler) {
        this.useSsl = useSsl;
        this.handler = handler;
        this.initClient();
    }

    public RestClient(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.initClient();
    }

    public RestClient(String proxyHost, int proxyPort, CustomHandler handler) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.initClient();
    }

    public RestClient(String proxyHost, int proxyPort, boolean useSsl) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.useSsl = true;
        this.initClient();
    }

    public RestClient(String proxyHost, int proxyPort, boolean useSsl, CustomHandler handler) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.handler = handler;
        this.useSsl = true;
        this.initClient();
    }

    public RestClient(String proxyHost, int proxyPort, String username, String password, boolean useSsl) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.username = username.toCharArray();
        this.password = password.toCharArray();
        this.useSsl = useSsl;
        this.initClient();
    }

    public RestClient(String proxyHost, int proxyPort, String username, String password, boolean useSsl, CustomPrinter logger) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.username = username.toCharArray();
        this.password = password.toCharArray();
        this.useSsl = useSsl;
        this.handler = new CustomHandler(logger);
        this.initClient();
    }

    public RestClient(String proxyHost, int proxyPort, String username, String password) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.username = username.toCharArray();
        this.password = password.toCharArray();
        this.initClient();
    }

    public RestClient(String proxyHost, int proxyPort, String username, String password, CustomPrinter logger) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.username = username.toCharArray();
        this.password = password.toCharArray();
        this.handler = new CustomHandler(logger);
        this.initClient();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RestClient{");
        sb.append("useSsl=");
        sb.append(this.useSsl);
        sb.append(", proxyHost=");
        sb.append(this.proxyHost);
        sb.append(", proxyPort=");
        sb.append(this.proxyPort);
        sb.append(", username=");
        sb.append(this.username);
        sb.append(", password=****}");
        return sb.toString();
    }
}

