/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.nexus.mojos;

import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.build.nexus.mojos.AbstractNexusStagingMojo;
import org.glassfish.nexus.client.NexusClientException;
import org.glassfish.nexus.client.StagingAggregation;
import org.glassfish.nexus.client.beans.MavenArtifactInfo;
import org.glassfish.nexus.client.beans.Repo;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishPromoteMojo
extends AbstractNexusStagingMojo {
    private String promotionProfile;
    private boolean autoClose;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> projectRepos;
    private List<RemoteRepository> pluginRepos;
    private String nexusPromotedRepoId;
    private String aggregationProfileId;

    private List<ArtifactResult> resolveTransitive(DefaultArtifact artifact) throws MojoFailureException {
        Dependency dependency = new Dependency((Artifact)artifact, "runtime");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(dependency);
        for (RemoteRepository repo : this.projectRepos) {
            collectRequest.addRepository(repo);
        }
        for (RemoteRepository pluginRepo : this.pluginRepos) {
            collectRequest.addRepository(pluginRepo);
        }
        DependencyNode node = null;
        try {
            node = this.repoSystem.collectDependencies(this.repoSession, collectRequest).getRoot();
        }
        catch (DependencyCollectionException ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(node, null);
        CollectRequest cr = new CollectRequest(dependency, this.projectRepos);
        try {
            return this.repoSystem.resolveDependencies(this.repoSession, dependencyRequest).getArtifactResults();
        }
        catch (DependencyResolutionException ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void nexusMojoExecute() throws NexusClientException, MojoFailureException {
        String repoGroup = null;
        for (RemoteRepository remoteRepo : this.projectRepos) {
            if (!remoteRepo.getId().equals(this.nexusPromotedRepoId)) continue;
            repoGroup = remoteRepo.getUrl().replaceFirst(this.nexusClient.getNexusURL() + "content/groups/", "");
        }
        if (repoGroup == null) {
            throw new MojoFailureException("unable to find a configured repository with id \"" + this.nexusPromotedRepoId + "\"");
        }
        if (this.stagingRepo.isOpen()) {
            if (this.autoClose) {
                this.stagingRepo.close("Autoclosing " + this.message);
            } else {
                throw new MojoFailureException("staging repository " + this.stagingRepo.getId() + " is open, use autoClose=true");
            }
        }
        StagingAggregation aggregation = new StagingAggregation(this.stagingRepo.promote(this.promotionProfile, this.message));
        Set<MavenArtifactInfo> artifactsInfo = this.stagingRepo.getContent();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("-- searching for transitive dependencies available in " + this.nexusPromotedRepoId + " --"));
        for (MavenArtifactInfo artifactInfo : artifactsInfo) {
            this.getLog().info((CharSequence)("processing " + artifactInfo));
            for (ArtifactResult result : this.resolveTransitive(new DefaultArtifact(artifactInfo.toString()))) {
                Repo grandParent;
                MavenArtifactInfo artifact = new MavenArtifactInfo(result.getArtifact().getGroupId(), result.getArtifact().getArtifactId(), result.getArtifact().getVersion(), result.getArtifact().getClassifier(), result.getArtifact().getExtension(), result.getArtifact().getFile());
                if (!this.nexusClient.existsInRepoGroup(repoGroup, artifact)) continue;
                this.getLog().info((CharSequence)(artifactInfo + " is available on " + this.nexusPromotedRepoId));
                Repo repo = this.nexusClient.getStagingRepo(artifact.getFile());
                if (repo == null || repo.equals(this.stagingRepo)) continue;
                Repo parent = repo.getParent();
                if (parent == null) {
                    parent = repo.promote(this.promotionProfile, this.message);
                }
                if ((grandParent = parent.getParent()) != null) {
                    if (grandParent.getProfileName().equals(this.aggregationProfileId)) {
                        this.getLog().info((CharSequence)(artifactInfo + " already promoted with " + this.aggregationProfileId));
                        this.getLog().info((CharSequence)("removing +" + artifactInfo + " from " + grandParent.getId()));
                        Set<Repo> uncles = grandParent.getGroupTree();
                        grandParent.drop("Dropping grandparent " + this.message);
                        uncles.remove(parent);
                        aggregation.aggregate(new StagingAggregation(uncles).promote(this.aggregationProfileId, this.message));
                        continue;
                    }
                    aggregation.aggregate(grandParent);
                    continue;
                }
                aggregation.aggregate(parent);
            }
        }
        aggregation.promote(this.aggregationProfileId, this.message);
    }
}

