/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gitlab4j.api.models.Commit;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Milestone;
import org.gitlab4j.api.models.Note;
import org.gitlab4j.api.models.Project;
import org.gitlab4j.api.models.SearchBlob;
import org.gitlab4j.api.models.Snippet;
import org.gitlab4j.api.models.User;
import org.gitlab4j.models.utils.JacksonJsonEnumHelper;

public interface Constants {
    public static final String TOTAL_HEADER = "X-Total";
    public static final String TOTAL_PAGES_HEADER = "X-Total-Pages";
    public static final String PER_PAGE = "X-Per-Page";
    public static final String PAGE_HEADER = "X-Page";
    public static final String NEXT_PAGE_HEADER = "X-Next-Page";
    public static final String PREV_PAGE_HEADER = "X-Prev-Page";
    public static final String PER_PAGE_PARAM = "per_page";
    public static final String PAGE_PARAM = "page";

    public static enum AutoCancelPendingPipelines {
        DISABLED,
        ENABLED;

        private static final JacksonJsonEnumHelper<AutoCancelPendingPipelines> enumHelper;

        @JsonCreator
        public static AutoCancelPendingPipelines forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<AutoCancelPendingPipelines>(AutoCancelPendingPipelines.class);
        }
    }

    public static enum ProjectFeatureVisibilityAccessLevel {
        DISABLED,
        PRIVATE,
        ENABLED,
        PUBLIC;

        private static final JacksonJsonEnumHelper<ProjectFeatureVisibilityAccessLevel> enumHelper;

        @JsonCreator
        public static ProjectFeatureVisibilityAccessLevel forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectFeatureVisibilityAccessLevel>(ProjectFeatureVisibilityAccessLevel.class);
        }
    }

    public static enum DefaultBranchProtectionLevel {
        NOT_PROTECTED(0),
        PARTIALLY_PROTECTED(1),
        FULLY_PROTECTED(2),
        PROTECTED_AGAINST_PUSHES(3),
        FULL_PROTECTION_AFTER_INITIAL_PUSH(4);

        @JsonValue
        private final int value;

        private DefaultBranchProtectionLevel(int value) {
            this.value = value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static enum SubgroupCreationLevel {
        OWNER,
        MAINTAINER;

        private static JacksonJsonEnumHelper<SubgroupCreationLevel> enumHelper;

        @JsonCreator
        public static SubgroupCreationLevel forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SubgroupCreationLevel>(SubgroupCreationLevel.class);
        }
    }

    public static enum ProjectCreationLevel {
        NOONE,
        DEVELOPER,
        MAINTAINER;

        private static JacksonJsonEnumHelper<ProjectCreationLevel> enumHelper;

        @JsonCreator
        public static ProjectCreationLevel forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectCreationLevel>(ProjectCreationLevel.class);
        }
    }

    public static enum EventScope {
        ALL;

        private static JacksonJsonEnumHelper<EventScope> enumHelper;

        @JsonCreator
        public static EventScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<EventScope>(EventScope.class);
        }
    }

    public static enum AutoDevopsDeployStrategy {
        CONTINUOUS,
        MANUAL,
        TIMED_INCREMENTAL;

        private static JacksonJsonEnumHelper<AutoDevopsDeployStrategy> enumHelper;

        @JsonCreator
        public static AutoDevopsDeployStrategy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<AutoDevopsDeployStrategy>(AutoDevopsDeployStrategy.class);
        }
    }

    public static enum BuildGitStrategy {
        FETCH,
        CLONE;

        private static JacksonJsonEnumHelper<BuildGitStrategy> enumHelper;

        @JsonCreator
        public static BuildGitStrategy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<BuildGitStrategy>(BuildGitStrategy.class);
        }
    }

    public static enum SquashOption {
        NEVER,
        ALWAYS,
        DEFAULT_ON,
        DEFAULT_OFF;

        private static JacksonJsonEnumHelper<SquashOption> enumHelper;

        @JsonCreator
        public static SquashOption forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SquashOption>(SquashOption.class);
        }
    }

    public static enum ProjectAccessTokenScope {
        API,
        READ_API,
        READ_REGISTRY,
        WRITE_REGISTRY,
        READ_REPOSITORY,
        WRITE_REPOSITORY,
        CREATE_RUNNER;

        private static JacksonJsonEnumHelper<ProjectAccessTokenScope> enumHelper;

        @JsonCreator
        public static ProjectAccessTokenScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectAccessTokenScope>(ProjectAccessTokenScope.class);
        }
    }

    public static enum DeployTokenScope {
        READ_REPOSITORY,
        READ_REGISTRY;

        private static JacksonJsonEnumHelper<DeployTokenScope> enumHelper;

        @JsonCreator
        public static DeployTokenScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<DeployTokenScope>(DeployTokenScope.class);
        }
    }

    public static enum DeploymentStatus {
        CREATED,
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELED;

        private static JacksonJsonEnumHelper<DeploymentStatus> enumHelper;

        @JsonCreator
        public static DeploymentStatus forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<DeploymentStatus>(DeploymentStatus.class);
        }
    }

    public static enum TodoType {
        ISSUE,
        MERGE_REQUEST;

        private static JacksonJsonEnumHelper<TodoType> enumHelper;

        @JsonCreator
        public static TodoType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoType>(TodoType.class, true, true);
        }
    }

    public static enum TodoState {
        PENDING,
        DONE;

        private static JacksonJsonEnumHelper<TodoState> enumHelper;

        @JsonCreator
        public static TodoState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoState>(TodoState.class);
        }
    }

    public static enum TodoAction {
        ASSIGNED,
        MENTIONED,
        BUILD_FAILED,
        MARKED,
        APPROVAL_REQUIRED,
        UNMERGEABLE,
        DIRECTLY_ADDRESSED;

        private static JacksonJsonEnumHelper<TodoAction> enumHelper;

        @JsonCreator
        public static TodoAction forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TodoAction>(TodoAction.class);
        }
    }

    public static class ProjectSearchScope<T> {
        private final String jsonName;
        private final Class<T> resultType;
        public static final ProjectSearchScope<SearchBlob> BLOBS = new ProjectSearchScope<SearchBlob>("blobs", SearchBlob.class);
        public static final ProjectSearchScope<Commit> COMMITS = new ProjectSearchScope<Commit>("commits", Commit.class);
        public static final ProjectSearchScope<Issue> ISSUES = new ProjectSearchScope<Issue>("issues", Issue.class);
        public static final ProjectSearchScope<MergeRequest> MERGE_REQUESTS = new ProjectSearchScope<MergeRequest>("merge_requests", MergeRequest.class);
        public static final ProjectSearchScope<Milestone> MILESTONES = new ProjectSearchScope<Milestone>("milestones", Milestone.class);
        public static final ProjectSearchScope<Note> NOTES = new ProjectSearchScope<Note>("notes", Note.class);
        public static final ProjectSearchScope<SearchBlob> WIKI_BLOBS = new ProjectSearchScope<SearchBlob>("wiki_blobs", SearchBlob.class);
        public static final ProjectSearchScope<User> USERS = new ProjectSearchScope<User>("users", User.class);
        private static final Map<String, ProjectSearchScope<?>> jsonLookup = Arrays.stream(new ProjectSearchScope[]{BLOBS, COMMITS, ISSUES, MERGE_REQUESTS, MILESTONES, NOTES, WIKI_BLOBS, USERS}).collect(Collectors.toMap(searchScope -> searchScope.jsonName, Function.identity()));

        public ProjectSearchScope(String jsonName, Class<T> resultType) {
            this.jsonName = jsonName;
            this.resultType = resultType;
        }

        public Class<T> getResultType() {
            return this.resultType;
        }

        @JsonCreator
        public static <T> ProjectSearchScope<T> forValue(String value) {
            return jsonLookup.get(value);
        }

        public static Set<String> values() {
            return jsonLookup.keySet();
        }

        @JsonValue
        public String toValue() {
            return this.jsonName;
        }

        public String toString() {
            return this.jsonName;
        }
    }

    public static class GroupSearchScope<T> {
        private final String jsonName;
        private final Class<T> resultType;
        public static final GroupSearchScope<Project> PROJECTS = new GroupSearchScope<Project>("projects", Project.class);
        public static final GroupSearchScope<Issue> ISSUES = new GroupSearchScope<Issue>("issues", Issue.class);
        public static final GroupSearchScope<MergeRequest> MERGE_REQUESTS = new GroupSearchScope<MergeRequest>("merge_requests", MergeRequest.class);
        public static final GroupSearchScope<Milestone> MILESTONES = new GroupSearchScope<Milestone>("milestones", Milestone.class);
        public static final GroupSearchScope<SearchBlob> WIKI_BLOBS = new GroupSearchScope<SearchBlob>("wiki_blobs", SearchBlob.class);
        public static final GroupSearchScope<Commit> COMMITS = new GroupSearchScope<Commit>("commits", Commit.class);
        public static final GroupSearchScope<SearchBlob> BLOBS = new GroupSearchScope<SearchBlob>("blobs", SearchBlob.class);
        public static final GroupSearchScope<Note> NOTES = new GroupSearchScope<Note>("notes", Note.class);
        public static final GroupSearchScope<User> USERS = new GroupSearchScope<User>("users", User.class);
        private static final Map<String, GroupSearchScope<?>> jsonLookup = Arrays.stream(new GroupSearchScope[]{PROJECTS, ISSUES, MERGE_REQUESTS, MILESTONES, WIKI_BLOBS, COMMITS, BLOBS, NOTES, USERS}).collect(Collectors.toMap(searchScope -> searchScope.jsonName, Function.identity()));

        public GroupSearchScope(String jsonName, Class<T> resultType) {
            this.jsonName = jsonName;
            this.resultType = resultType;
        }

        public Class<T> getResultType() {
            return this.resultType;
        }

        @JsonCreator
        public static <T> GroupSearchScope<T> forValue(String value) {
            return jsonLookup.get(value);
        }

        public static Set<String> values() {
            return jsonLookup.keySet();
        }

        @JsonValue
        public String toValue() {
            return this.jsonName;
        }

        public String toString() {
            return this.jsonName;
        }
    }

    public static class SearchScope<T> {
        private final String jsonName;
        private final Class<T> resultType;
        public static final SearchScope<Project> PROJECTS = new SearchScope<Project>("projects", Project.class);
        public static final SearchScope<Issue> ISSUES = new SearchScope<Issue>("issues", Issue.class);
        public static final SearchScope<MergeRequest> MERGE_REQUESTS = new SearchScope<MergeRequest>("merge_requests", MergeRequest.class);
        public static final SearchScope<Milestone> MILESTONES = new SearchScope<Milestone>("milestones", Milestone.class);
        public static final SearchScope<Snippet> SNIPPET_TITLES = new SearchScope<Snippet>("snippet_titles", Snippet.class);
        public static final SearchScope<Snippet> SNIPPET_BLOBS = new SearchScope<Snippet>("snippet_blobs", Snippet.class);
        public static final SearchScope<User> USERS = new SearchScope<User>("users", User.class);
        public static final SearchScope<SearchBlob> BLOBS = new SearchScope<SearchBlob>("blobs", SearchBlob.class);
        public static final SearchScope<Commit> COMMITS = new SearchScope<Commit>("commits", Commit.class);
        public static final SearchScope<SearchBlob> WIKI_BLOBS = new SearchScope<SearchBlob>("wiki_blobs", SearchBlob.class);
        private static final Map<String, SearchScope<?>> jsonLookup = Arrays.stream(new SearchScope[]{PROJECTS, ISSUES, MERGE_REQUESTS, MILESTONES, SNIPPET_TITLES, SNIPPET_BLOBS, USERS, BLOBS, COMMITS, WIKI_BLOBS}).collect(Collectors.toMap(searchScope -> searchScope.jsonName, Function.identity()));

        private SearchScope(String jsonName, Class<T> resultType) {
            this.jsonName = jsonName;
            this.resultType = resultType;
        }

        public Class<T> getResultType() {
            return this.resultType;
        }

        @JsonCreator
        public static <T> SearchScope<T> forValue(String value) {
            return jsonLookup.get(value);
        }

        public static Set<String> values() {
            return jsonLookup.keySet();
        }

        @JsonValue
        public String toValue() {
            return this.jsonName;
        }

        public String toString() {
            return this.jsonName;
        }
    }

    public static enum ApplicationScope {
        API,
        READ_API,
        READ_USER,
        CREATE_RUNNER,
        MANAGE_RUNNER,
        K8S_PROXY,
        READ_REPOSITORY,
        WRITE_REPOSITORY,
        READ_OBSERVABILITY,
        WRITE_OBSERVABILITY,
        AI_FEATURES,
        SUDO,
        ADMIN_MODE,
        READ_SERVICE_PING,
        OPENID,
        PROFILE,
        EMAIL;

        private static JacksonJsonEnumHelper<ApplicationScope> enumHelper;

        @JsonCreator
        public static ApplicationScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ApplicationScope>(ApplicationScope.class);
        }
    }

    public static enum CommitBuildState {
        PENDING,
        RUNNING,
        SUCCESS,
        FAILED,
        CANCELED,
        SKIPPED;

        private static JacksonJsonEnumHelper<CommitBuildState> enumHelper;

        @JsonCreator
        public static CommitBuildState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<CommitBuildState>(CommitBuildState.class);
        }
    }

    public static enum ArchiveFormat {
        BZ2,
        TAR,
        TAR_BZ2,
        TAR_GZ,
        TB2,
        TBZ,
        TBZ2,
        ZIP;

        private final String value = this.name().toLowerCase().replace('_', '.');
        private static Map<String, ArchiveFormat> valuesMap;

        public static ArchiveFormat forValue(String value) {
            if (value == null || value.trim().isEmpty()) {
                return null;
            }
            ArchiveFormat archiveFormat = valuesMap.get(value);
            if (archiveFormat != null) {
                return archiveFormat;
            }
            throw new IllegalArgumentException("Invalid format! Options are tar.gz, tar.bz2, tbz, tbz2, tb2, bz2, tar, and zip.");
        }

        public String toString() {
            return this.value;
        }

        static {
            valuesMap = new HashMap<String, ArchiveFormat>(8);
            for (ArchiveFormat archiveFormat : ArchiveFormat.values()) {
                valuesMap.put(archiveFormat.value, archiveFormat);
            }
        }
    }

    public static enum ImpersonationState {
        ALL,
        ACTIVE,
        INACTIVE;

        private static JacksonJsonEnumHelper<ImpersonationState> enumHelper;

        @JsonCreator
        public static ImpersonationState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ImpersonationState>(ImpersonationState.class);
        }
    }

    public static enum LineType {
        OLD,
        NEW;

        private static JacksonJsonEnumHelper<LineType> enumHelper;

        @JsonCreator
        public static LineType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<LineType>(LineType.class);
        }
    }

    public static enum TargetType {
        ISSUE,
        MILESTONE,
        MERGE_REQUEST,
        NOTE,
        PROJECT,
        SNIPPET,
        USER;

        private static JacksonJsonEnumHelper<TargetType> enumHelper;

        @JsonCreator
        public static TargetType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TargetType>(TargetType.class, true, false, true);
        }
    }

    public static enum ActionType {
        CREATED,
        UPDATED,
        OPENED,
        CLOSED,
        REOPENED,
        PUSHED,
        COMMENTED,
        MERGED,
        JOINED,
        LEFT,
        DESTROYED,
        EXPIRED,
        REMOVED,
        DELETED,
        APPROVED,
        ACCEPTED,
        IMPORTED;

        private static JacksonJsonEnumHelper<ActionType> enumHelper;

        @JsonCreator
        public static ActionType forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ActionType>(ActionType.class);
        }
    }

    public static enum MilestoneState {
        ACTIVE,
        CLOSED,
        ACTIVATE,
        CLOSE;

        private static JacksonJsonEnumHelper<MilestoneState> enumHelper;

        @JsonCreator
        public static MilestoneState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MilestoneState>(MilestoneState.class);
        }
    }

    public static enum IssueState {
        OPENED,
        CLOSED,
        REOPENED;

        private static JacksonJsonEnumHelper<IssueState> enumHelper;

        @JsonCreator
        public static IssueState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueState>(IssueState.class);
        }
    }

    public static enum StateEvent {
        CLOSE,
        REOPEN;

        private static JacksonJsonEnumHelper<StateEvent> enumHelper;

        @JsonCreator
        public static StateEvent forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<StateEvent>(StateEvent.class);
        }
    }

    public static enum MergeRequestSearchIn {
        TITLE,
        DESCRIPTION;

        private static JacksonJsonEnumHelper<MergeRequestSearchIn> enumHelper;

        @JsonCreator
        public static MergeRequestSearchIn forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestSearchIn>(MergeRequestSearchIn.class);
        }
    }

    public static enum MergeRequestState {
        OPENED,
        CLOSED,
        LOCKED,
        MERGED,
        ALL;

        private static JacksonJsonEnumHelper<MergeRequestState> enumHelper;

        @JsonCreator
        public static MergeRequestState forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestState>(MergeRequestState.class);
        }
    }

    public static enum MergeRequestScope {
        CREATED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

        private static JacksonJsonEnumHelper<MergeRequestScope> enumHelper;

        @JsonCreator
        public static MergeRequestScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestScope>(MergeRequestScope.class);
        }
    }

    public static enum IssueScope {
        CREATED_BY_ME,
        ASSIGNED_TO_ME,
        ALL;

        private static JacksonJsonEnumHelper<IssueScope> enumHelper;

        @JsonCreator
        public static IssueScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueScope>(IssueScope.class);
        }
    }

    public static enum JobScope {
        CREATED,
        PENDING,
        RUNNING,
        FAILED,
        SUCCESS,
        CANCELED,
        CANCELING,
        PREPARING,
        SCHEDULED,
        SKIPPED,
        MANUAL,
        WAITING_FOR_RESOURCE;

        private static JacksonJsonEnumHelper<JobScope> enumHelper;

        @JsonCreator
        public static JobScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<JobScope>(JobScope.class);
        }
    }

    public static enum PipelineSource {
        PUSH,
        WEB,
        TRIGGER,
        SCHEDULE,
        API,
        EXTERNAL,
        PIPELINE,
        CHAT,
        WEBIDE,
        MERGE_REQUEST_EVENT,
        EXTERNAL_PULL_REQUEST_EVENT;

        private static JacksonJsonEnumHelper<PipelineSource> enumHelper;

        @JsonCreator
        public static PipelineSource forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineSource>(PipelineSource.class);
        }
    }

    public static enum PipelineScope {
        RUNNING,
        PENDING,
        FINISHED,
        BRANCHES,
        TAGS;

        private static JacksonJsonEnumHelper<PipelineScope> enumHelper;

        @JsonCreator
        public static PipelineScope forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineScope>(PipelineScope.class);
        }
    }

    public static enum ContributorOrderBy {
        NAME,
        EMAIL,
        COMMITS;

        private static JacksonJsonEnumHelper<ContributorOrderBy> enumHelper;

        @JsonCreator
        public static ContributorOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ContributorOrderBy>(ContributorOrderBy.class);
        }
    }

    public static enum DeploymentOrderBy {
        ID,
        IID,
        CREATED_AT,
        UPDATED_AT,
        REF;

        private static JacksonJsonEnumHelper<DeploymentOrderBy> enumHelper;

        @JsonCreator
        public static DeploymentOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<DeploymentOrderBy>(DeploymentOrderBy.class);
        }
    }

    public static enum TagOrderBy {
        NAME,
        UPDATED;

        private static JacksonJsonEnumHelper<TagOrderBy> enumHelper;

        @JsonCreator
        public static TagOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<TagOrderBy>(TagOrderBy.class);
        }
    }

    public static enum GroupOrderBy {
        NAME,
        PATH,
        ID,
        SIMILARITY;

        private static JacksonJsonEnumHelper<GroupOrderBy> enumHelper;

        @JsonCreator
        public static GroupOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<GroupOrderBy>(GroupOrderBy.class);
        }
    }

    public static enum MergeRequestOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<MergeRequestOrderBy> enumHelper;

        @JsonCreator
        public static MergeRequestOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<MergeRequestOrderBy>(MergeRequestOrderBy.class);
        }
    }

    public static enum PipelineOrderBy {
        ID,
        STATUS,
        REF,
        UPDATED_AT,
        USER_ID;

        private static JacksonJsonEnumHelper<PipelineOrderBy> enumHelper;

        @JsonCreator
        public static PipelineOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PipelineOrderBy>(PipelineOrderBy.class);
        }
    }

    public static enum ProjectOrderBy {
        ID,
        NAME,
        PATH,
        CREATED_AT,
        UPDATED_AT,
        LAST_ACTIVITY_AT;

        private static JacksonJsonEnumHelper<ProjectOrderBy> enumHelper;

        @JsonCreator
        public static ProjectOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<ProjectOrderBy>(ProjectOrderBy.class);
        }
    }

    public static enum PackageStatus {
        DEFAULT,
        HIDDEN,
        PROCESSING;

        private static JacksonJsonEnumHelper<PackageStatus> enumHelper;

        @JsonCreator
        public static PackageStatus forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PackageStatus>(PackageStatus.class);
        }
    }

    public static enum PackageOrderBy {
        NAME,
        CREATED_AT,
        VERSION,
        TYPE,
        PROJECT_PATH;

        private static JacksonJsonEnumHelper<PackageOrderBy> enumHelper;

        @JsonCreator
        public static PackageOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<PackageOrderBy>(PackageOrderBy.class);
        }
    }

    public static enum IssueOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<IssueOrderBy> enumHelper;

        @JsonCreator
        public static IssueOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<IssueOrderBy>(IssueOrderBy.class);
        }
    }

    public static enum EpicOrderBy {
        CREATED_AT,
        UPDATED_AT;

        private static JacksonJsonEnumHelper<EpicOrderBy> enumHelper;

        @JsonCreator
        public static EpicOrderBy forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<EpicOrderBy>(EpicOrderBy.class);
        }
    }

    public static enum SortOrder {
        ASC,
        DESC;

        private static JacksonJsonEnumHelper<SortOrder> enumHelper;

        @JsonCreator
        public static SortOrder forValue(String value) {
            return enumHelper.forValue(value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<SortOrder>(SortOrder.class);
        }
    }

    public static enum Encoding {
        TEXT,
        BASE64;

        private static JacksonJsonEnumHelper<Encoding> enumHelper;

        @JsonCreator
        public static Encoding forValue(String value) {
            return enumHelper.forValue(value != null ? value.toLowerCase() : value);
        }

        @JsonValue
        public String toValue() {
            return enumHelper.toString(this);
        }

        public String toString() {
            return enumHelper.toString(this);
        }

        static {
            enumHelper = new JacksonJsonEnumHelper<Encoding>(Encoding.class);
        }
    }

    public static enum TokenType {
        ACCESS,
        OAUTH2_ACCESS,
        JOB_TOKEN,
        PRIVATE;

    }
}

