/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Board;
import org.gitlab4j.api.models.BoardList;

public class BoardsApi
extends AbstractApi {
    public BoardsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Board> getBoards(Object projectIdOrPath) throws GitLabApiException {
        return this.getBoards(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Board> getBoards(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards");
        return (List)response.readEntity((GenericType)new GenericType<List<Board>>(){});
    }

    public Pager<Board> getBoards(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Board>(this, Board.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards");
    }

    public Stream<Board> getBoardsStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getBoards(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Board getBoard(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
        return (Board)response.readEntity(Board.class);
    }

    public Optional<Board> getOptionalBoard(Object projectIdOrPath, Long boardId) {
        try {
            return Optional.ofNullable(this.getBoard(projectIdOrPath, boardId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Board createBoard(Object projectIdOrPath, String name) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "boards"});
        return (Board)response.readEntity(Board.class);
    }

    public BoardList updateBoard(Object projectIdOrPath, Long boardId, String name, Long assigneeId, Long milestoneId, String labels, Integer weight) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("name", name).withParam("assignee_id", assigneeId).withParam("milestone_id", milestoneId).withParam("labels", labels).withParam("weight", weight);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId});
        return (BoardList)response.readEntity(BoardList.class);
    }

    public void deleteBoard(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId);
    }

    public List<BoardList> getBoardLists(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        return this.getBoardLists(projectIdOrPath, boardId, this.getDefaultPerPage()).all();
    }

    public List<BoardList> getBoardLists(Object projectIdOrPath, Long boardId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists");
        return (List)response.readEntity((GenericType)new GenericType<List<BoardList>>(){});
    }

    public Pager<BoardList> getBoardLists(Object projectIdOrPath, Long boardId, int itemsPerPage) throws GitLabApiException {
        return new Pager<BoardList>(this, BoardList.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists");
    }

    public Stream<BoardList> getBoardsListsStream(Object projectIdOrPath, Long boardId) throws GitLabApiException {
        return this.getBoardLists(projectIdOrPath, boardId, this.getDefaultPerPage()).stream();
    }

    public BoardList getBoardList(Object projectIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
        return (BoardList)response.readEntity(BoardList.class);
    }

    public Optional<BoardList> getOptionalBoardList(Object projectIdOrPath, Long boardId, Long listId) {
        try {
            return Optional.ofNullable(this.getBoardList(projectIdOrPath, boardId, listId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public BoardList createBoardList(Object projectIdOrPath, Long boardId, Long labelId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("label_id", labelId, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists"});
        return (BoardList)response.readEntity(BoardList.class);
    }

    public BoardList updateBoardList(Object projectIdOrPath, Long boardId, Long listId, Integer position) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("position", position, true);
        Response response = this.putWithFormData(Response.Status.OK, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
        return (BoardList)response.readEntity(BoardList.class);
    }

    public void deleteBoardList(Object projectIdOrPath, Long boardId, Long listId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "boards", boardId, "lists", listId);
    }
}

