/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Pipeline;
import org.gitlab4j.api.models.PipelineStatus;

public class PipelineApi
extends AbstractApi
implements Constants {
    public PipelineApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Pipeline> getPipelines(Object projectIdOrPath) throws GitLabApiException {
        return this.getPipelines(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Pipeline> getPipelines(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines");
        return (List)response.readEntity((GenericType)new GenericType<List<Pipeline>>(){});
    }

    public Pager<Pipeline> getPipelines(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Pipeline>(this, Pipeline.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines");
    }

    public Stream<Pipeline> getPipelinesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getPipelines(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Pipeline> getPipelines(Object projectIdOrPath, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort) throws GitLabApiException {
        return this.getPipelines(projectIdOrPath, scope, status, ref, yamlErrors, name, username, orderBy, sort, this.getDefaultPerPage()).all();
    }

    public List<Pipeline> getPipelines(Object projectIdOrPath, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("status", (Object)status).withParam("ref", ref).withParam("yaml_errors", yamlErrors).withParam("name", name).withParam("username", username).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines");
        return (List)response.readEntity((GenericType)new GenericType<List<Pipeline>>(){});
    }

    public Stream<Pipeline> getPipelinesStream(Object projectIdOrPath, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort) throws GitLabApiException {
        return this.getPipelines(projectIdOrPath, scope, status, ref, yamlErrors, name, username, orderBy, sort, this.getDefaultPerPage()).stream();
    }

    public Pager<Pipeline> getPipelines(Object projectIdOrPath, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("status", (Object)status).withParam("ref", ref).withParam("yaml_errors", yamlErrors).withParam("name", name).withParam("username", username).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort);
        return new Pager<Pipeline>(this, Pipeline.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines");
    }

    public Pipeline getPipeline(Object projectIdOrPath, int pipelineId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId);
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public Pipeline createPipeline(Object projectIdOrPath, String ref) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", ref);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public Pipeline retryPipelineJob(Object projectIdOrPath, int pipelineId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.OK, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "retry"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public Pipeline cancelPipelineJobs(Object projectIdOrPath, int pipelineId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.OK, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "cancel"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }
}

