/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.utils.JacksonJson;

public class Pager<T>
implements Iterator<List<T>>,
Constants {
    private int itemsPerPage;
    private int totalPages;
    private int totalItems;
    private int currentPage;
    private List<String> pageParam = new ArrayList<String>(1);
    private List<T> currentItems;
    private AbstractApi api;
    private MultivaluedMap<String, String> queryParams;
    private Object[] pathArgs;
    private static JacksonJson jacksonJson = new JacksonJson();
    private static ObjectMapper mapper = jacksonJson.getObjectMapper();
    private JavaType javaType;

    Pager(AbstractApi api, Class<T> type, int itemsPerPage, MultivaluedMap<String, String> queryParams, Object ... pathArgs) throws GitLabApiException {
        this.javaType = mapper.getTypeFactory().constructCollectionType(List.class, type);
        if (queryParams == null) {
            queryParams = new GitLabApiForm().withParam("per_page", itemsPerPage).asMap();
        } else {
            queryParams.remove((Object)"per_page");
            queryParams.add((Object)"per_page", (Object)Integer.toString(itemsPerPage));
        }
        this.pageParam = new ArrayList<String>();
        this.pageParam.add("1");
        queryParams.put((Object)"page", this.pageParam);
        Response response = api.get(Response.Status.OK, (MultivaluedMap<String, String>)queryParams, pathArgs);
        try {
            this.currentItems = (List)mapper.readValue((InputStream)response.getEntity(), this.javaType);
        }
        catch (Exception e) {
            throw new GitLabApiException(e);
        }
        this.api = api;
        this.queryParams = queryParams;
        this.pathArgs = pathArgs;
        try {
            this.itemsPerPage = this.getHeaderValue(response, "X-Per-Page");
            this.totalPages = this.getHeaderValue(response, "X-Total-Pages");
            this.totalItems = this.getHeaderValue(response, "X-Total");
        }
        catch (GitLabApiException glae) {
            if (this.currentItems != null && this.currentItems.size() < itemsPerPage) {
                this.itemsPerPage = itemsPerPage;
                this.totalPages = 1;
                this.totalItems = this.currentItems.size();
            }
            throw glae;
        }
    }

    private int getHeaderValue(Response response, String key) throws GitLabApiException {
        String value = response.getHeaderString(key);
        String string = value = value != null ? value.trim() : null;
        if (value == null || value.length() == 0) {
            throw new GitLabApiException("Missing '" + key + "' header from server");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new GitLabApiException("Invalid '" + key + "' header value (" + value + ") from server");
        }
    }

    private void setPageParam(int page) {
        this.pageParam.set(0, Integer.toString(page));
        this.queryParams.put((Object)"page", this.pageParam);
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean hasNext() {
        return this.currentPage < this.totalPages;
    }

    @Override
    public List<T> next() {
        return this.page(this.currentPage + 1);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public List<T> first() throws GitLabApiException {
        return this.page(1);
    }

    public List<T> last() throws GitLabApiException {
        return this.page(this.totalPages);
    }

    public List<T> previous() throws GitLabApiException {
        return this.page(this.currentPage - 1);
    }

    public List<T> current() throws GitLabApiException {
        return this.page(this.currentPage);
    }

    public List<T> page(int pageNumber) {
        if (pageNumber > this.totalPages) {
            throw new NoSuchElementException();
        }
        if (pageNumber < 1) {
            throw new NoSuchElementException();
        }
        if (this.currentPage == 0 && pageNumber == 1) {
            this.currentPage = 1;
            return this.currentItems;
        }
        if (this.currentPage == pageNumber) {
            return this.currentItems;
        }
        try {
            this.setPageParam(pageNumber);
            Response response = this.api.get(Response.Status.OK, this.queryParams, this.pathArgs);
            this.currentItems = (List)mapper.readValue((InputStream)response.getEntity(), this.javaType);
            this.currentPage = pageNumber;
            return this.currentItems;
        }
        catch (IOException | GitLabApiException e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> all() throws GitLabApiException {
        this.currentPage = 0;
        ArrayList allItems = new ArrayList(this.totalItems);
        while (this.hasNext()) {
            allItems.addAll(this.next());
        }
        return allItems;
    }

    public Stream<T> stream() throws GitLabApiException {
        this.currentPage = 0;
        Stream.Builder streamBuilder = Stream.builder();
        while (this.hasNext()) {
            this.next().forEach(streamBuilder);
        }
        return streamBuilder.build();
    }
}

