/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Duration;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.IssueFilter;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.TimeStats;
import org.gitlab4j.api.utils.DurationUtils;

public class IssuesApi
extends AbstractApi
implements Constants {
    public IssuesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Issue> getIssues() throws GitLabApiException {
        return this.getIssues(1, this.getDefaultPerPage());
    }

    public List<Issue> getIssues(int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getIssues(int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "issues");
    }

    public List<Issue> getIssues(Integer projectId) throws GitLabApiException {
        return this.getIssues(projectId, 1, this.getDefaultPerPage());
    }

    public List<Issue> getIssues(Integer projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getIssues(Integer projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Issue>(this, Issue.class, itemsPerPage, null, "projects", projectId, "issues");
    }

    public List<Issue> getIssues(Object projectIdOrPath, IssueFilter filter) throws GitLabApiException {
        return this.getIssues(projectIdOrPath, filter, 1, this.getDefaultPerPage());
    }

    public List<Issue> getIssues(Object projectIdOrPath, IssueFilter filter, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams(page, perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getIssues(Object projectIdOrPath, IssueFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Issue>(this, Issue.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues");
    }

    public List<Issue> getIssues(IssueFilter filter) throws GitLabApiException {
        return this.getIssues(filter, 1, this.getDefaultPerPage());
    }

    public List<Issue> getIssues(IssueFilter filter, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams(page, perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public Pager<Issue> getIssues(IssueFilter filter, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = filter.getQueryParams();
        return new Pager<Issue>(this, Issue.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "issues");
    }

    public Issue getIssue(Integer projectId, Integer issueId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "issues", issueId);
        return (Issue)response.readEntity(Issue.class);
    }

    public Optional<Issue> getOptionalIssue(Integer projectId, Integer issueId) {
        try {
            return Optional.ofNullable(this.getIssue(projectId, issueId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Issue createIssue(Integer projectId, String title, String description) throws GitLabApiException {
        return this.createIssue(projectId, title, description, null, null, null, null, null, null, null, null);
    }

    public Issue createIssue(Integer projectId, String title, String description, Boolean confidential, List<Integer> assigneeIds, Integer milestoneId, String labels, Date createdAt, Date dueDate, Integer mergeRequestToResolveId, Integer discussionToResolveId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("confidential", confidential).withParam("assignee_ids", assigneeIds).withParam("milestone_id", milestoneId).withParam("labels", labels).withParam("created_at", createdAt).withParam("due_date", dueDate).withParam("merge_request_to_resolve_discussions_of", mergeRequestToResolveId).withParam("discussion_to_resolve", discussionToResolveId);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", projectId, "issues"});
        return (Issue)response.readEntity(Issue.class);
    }

    public Issue closeIssue(Integer projectId, Integer issueIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("project ID cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state_event", (Object)Constants.StateEvent.CLOSE);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "issues", issueIid);
        return (Issue)response.readEntity(Issue.class);
    }

    public Issue updateIssue(Integer projectId, Integer issueIid, String title, String description, Boolean confidential, List<Integer> assigneeIds, Integer milestoneId, String labels, Constants.StateEvent stateEvent, Date updatedAt, Date dueDate) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("project ID cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("confidential", confidential).withParam("assignee_ids", assigneeIds).withParam("milestone_id", milestoneId).withParam("labels", labels).withParam("state_event", (Object)stateEvent).withParam("updated_at", updatedAt).withParam("due_date", dueDate);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "issues", issueIid);
        return (Issue)response.readEntity(Issue.class);
    }

    public void deleteIssue(Integer projectId, Integer issueIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, this.getDefaultPerPageParam(), "projects", projectId, "issues", issueIid);
    }

    public TimeStats estimateTime(Integer projectId, Integer issueIid, int duration) throws GitLabApiException {
        return this.estimateTime(projectId, issueIid, new Duration(duration));
    }

    public TimeStats estimateTime(Integer projectId, Integer issueIid, String duration) throws GitLabApiException {
        return this.estimateTime(projectId, issueIid, new Duration(duration));
    }

    public TimeStats estimateTime(Integer projectId, Integer issueIid, Duration duration) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        String durationString = duration != null ? DurationUtils.toString(duration.getSeconds(), false) : null;
        GitLabApiForm formData = new GitLabApiForm().withParam("duration", durationString, true);
        Response response = this.post(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", projectId, "issues", issueIid, "time_estimate"});
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public TimeStats resetEstimatedTime(Integer projectId, Integer issueIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        Response response = this.post(Response.Status.OK, (MultivaluedMap<String, String>)new GitLabApiForm().asMap(), new Object[]{"projects", projectId, "issues", issueIid, "reset_time_estimate"});
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public TimeStats addSpentTime(Integer projectId, Integer issueIid, int duration) throws GitLabApiException {
        return this.addSpentTime(projectId, issueIid, new Duration(duration));
    }

    public TimeStats addSpentTime(Integer projectId, Integer issueIid, String duration) throws GitLabApiException {
        return this.addSpentTime(projectId, issueIid, new Duration(duration));
    }

    public TimeStats addSpentTime(Integer projectId, Integer issueIid, Duration duration) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        String durationString = duration != null ? DurationUtils.toString(duration.getSeconds(), false) : null;
        GitLabApiForm formData = new GitLabApiForm().withParam("duration", durationString, true);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", projectId, "issues", issueIid, "add_spent_time"});
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public TimeStats resetSpentTime(Integer projectId, Integer issueIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        Response response = this.post(Response.Status.OK, (MultivaluedMap<String, String>)new GitLabApiForm().asMap(), new Object[]{"projects", projectId, "issues", issueIid, "reset_spent_time"});
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public TimeStats getTimeTrackingStats(Integer projectId, Integer issueIid) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (issueIid == null) {
            throw new RuntimeException("issue IID cannot be null");
        }
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)new GitLabApiForm().asMap(), "projects", projectId, "issues", issueIid, "time_stats");
        return (TimeStats)response.readEntity(TimeStats.class);
    }

    public Optional<TimeStats> getOptionalTimeTrackingStats(Integer projectId, Integer issueIid) {
        try {
            return Optional.ofNullable(this.getTimeTrackingStats(projectId, issueIid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public List<MergeRequest> getClosedByMergeRequests(Object projectIdOrPath, Integer issueIid) throws GitLabApiException {
        return this.getClosedByMergeRequests(projectIdOrPath, issueIid, 1, this.getDefaultPerPage());
    }

    public List<MergeRequest> getClosedByMergeRequests(Object projectIdOrPath, Integer issueIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "closed_by");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Pager<MergeRequest> getClosedByMergeRequests(Object projectIdOrPath, Integer issueIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<MergeRequest>(this, MergeRequest.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "issues", issueIid, "closed_by");
    }
}

