/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Epic;
import org.gitlab4j.api.models.EpicIssue;

public class EpicsApi
extends AbstractApi {
    public EpicsApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Epic> getEpics(Object groupIdOrPath) throws GitLabApiException {
        return this.getEpics(groupIdOrPath, 1, this.getDefaultPerPage());
    }

    public List<Epic> getEpics(Object groupIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics");
        return (List)response.readEntity((GenericType)new GenericType<List<Epic>>(){});
    }

    public Pager<Epic> getEpics(Object groupIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Epic>(this, Epic.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics");
    }

    public List<Epic> getEpics(Object groupIdOrPath, Integer authorId, String labels, Constants.EpicOrderBy orderBy, Constants.SortOrder sortOrder, String search) throws GitLabApiException {
        return this.getEpics(groupIdOrPath, authorId, labels, orderBy, sortOrder, search, 1, this.getDefaultPerPage());
    }

    public List<Epic> getEpics(Object groupIdOrPath, Integer authorId, String labels, Constants.EpicOrderBy orderBy, Constants.SortOrder sortOrder, String search, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(page, perPage).withParam("author_id", authorId).withParam("labels", labels).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sortOrder).withParam("search", search);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics");
        return (List)response.readEntity((GenericType)new GenericType<List<Epic>>(){});
    }

    public Pager<Epic> getEpics(Object groupIdOrPath, Integer authorId, String labels, Constants.EpicOrderBy orderBy, Constants.SortOrder sortOrder, String search, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("author_id", authorId).withParam("labels", labels).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sortOrder).withParam("search", search);
        return new Pager<Epic>(this, Epic.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics");
    }

    public Epic getEpic(Object groupIdOrPath, Integer epicIid) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid);
        return (Epic)response.readEntity(Epic.class);
    }

    public Optional<Epic> getOptionalEpic(Object groupIdOrPath, Integer epicIid) {
        try {
            return Optional.ofNullable(this.getEpic(groupIdOrPath, epicIid));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Epic createEpic(Object groupIdOrPath, String title, String labels, String description, Date startDate, Date endDate) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("labels", labels).withParam("description", description).withParam("start_date", startDate).withParam("end_date", endDate);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics"});
        return (Epic)response.readEntity(Epic.class);
    }

    public Epic createEpic(Object groupIdOrPath, Epic epic) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", epic.getTitle(), true).withParam("labels", epic.getLabels()).withParam("description", epic.getDescription()).withParam("start_date", epic.getStartDate()).withParam("end_date", epic.getEndDate());
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics"});
        return (Epic)response.readEntity(Epic.class);
    }

    public Epic updateEpic(Object groupIdOrPath, Integer epicIid, String title, String labels, String description, Date startDate, Date endDate) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("labels", labels).withParam("description", description).withParam("start_date", startDate).withParam("end_date", endDate);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid);
        return (Epic)response.readEntity(Epic.class);
    }

    public Epic updateEpic(Object groupIdOrPath, Integer epicIid, Epic epic) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("title", epic.getTitle(), true).withParam("labels", epic.getLabels()).withParam("description", epic.getDescription()).withParam("start_date", epic.getStartDate()).withParam("end_date", epic.getEndDate());
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid);
        return (Epic)response.readEntity(Epic.class);
    }

    public void deleteEpic(Object groupIdOrPath, Integer epicIid) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid);
    }

    public List<Epic> getEpicIssues(Object groupIdOrPath, Integer epicIid) throws GitLabApiException {
        return this.getEpicIssues(groupIdOrPath, epicIid, 1, this.getDefaultPerPage());
    }

    public List<Epic> getEpicIssues(Object groupIdOrPath, Integer epicIid, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Epic>>(){});
    }

    public Pager<Epic> getEpicIssues(Object groupIdOrPath, Integer epicIid, int itemsPerPage) throws GitLabApiException {
        return new Pager<Epic>(this, Epic.class, itemsPerPage, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues");
    }

    public EpicIssue assignIssue(Object groupIdOrPath, Integer epicIid, Integer issueIid) throws GitLabApiException {
        Response response = this.post(Response.Status.CREATED, (Form)null, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues", issueIid});
        return (EpicIssue)response.readEntity(EpicIssue.class);
    }

    public EpicIssue removeIssue(Object groupIdOrPath, Integer epicIid, Integer issueIid) throws GitLabApiException {
        Response response = this.delete(Response.Status.OK, null, "groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues", issueIid);
        return (EpicIssue)response.readEntity(EpicIssue.class);
    }

    public EpicIssue updateIssue(Object groupIdOrPath, Integer epicIid, Integer issueIid, Integer moveBeforeId, Integer moveAfterId) throws GitLabApiException {
        GitLabApiForm form = new GitLabApiForm().withParam("move_before_id", moveBeforeId).withParam("move_after_id", moveAfterId);
        Response response = this.post(Response.Status.OK, (Form)form, new Object[]{"groups", this.getGroupIdOrPath(groupIdOrPath), "epics", epicIid, "issues", issueIid});
        return (EpicIssue)response.readEntity(EpicIssue.class);
    }
}

