/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.RepositoryFile;

public class RepositoryFileApi
extends AbstractApi {
    public RepositoryFileApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public RepositoryFile getFile(String filePath, Integer projectId, String ref) throws GitLabApiException {
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            return this.getFileV3(filePath, projectId, ref);
        }
        Form form = new Form();
        this.addFormParam(form, "ref", ref, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", projectId, "repository", "files", this.urlEncode(filePath));
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    protected RepositoryFile getFileV3(String filePath, Integer projectId, String ref) throws GitLabApiException {
        Form form = new Form();
        this.addFormParam(form, "file_path", filePath, true);
        this.addFormParam(form, "ref", ref, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", projectId, "repository", "files");
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public RepositoryFile createFile(RepositoryFile file, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.createForm(file, branchName, commitMessage);
        Response response = this.isApiVersion(GitLabApi.ApiVersion.V3) ? this.post(Response.Status.CREATED, formData, new Object[]{"projects", projectId, "repository", "files"}) : this.post(Response.Status.CREATED, formData, new Object[]{"projects", projectId, "repository", "files", this.urlEncode(file.getFilePath())});
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public RepositoryFile updateFile(RepositoryFile file, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.createForm(file, branchName, commitMessage);
        Response response = this.isApiVersion(GitLabApi.ApiVersion.V3) ? this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "files") : this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "repository", "files", this.urlEncode(file.getFilePath()));
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public void deleteFile(String filePath, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        Response.Status expectedStatus;
        if (filePath == null) {
            throw new RuntimeException("filePath cannot be null");
        }
        Form form = new Form();
        this.addFormParam(form, this.isApiVersion(GitLabApi.ApiVersion.V3) ? "branch_name" : "branch", branchName, true);
        this.addFormParam(form, "commit_message", commitMessage, true);
        Response.Status status = expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            this.addFormParam(form, "file_path", filePath, true);
            this.delete(expectedStatus, (MultivaluedMap<String, String>)form.asMap(), "projects", projectId, "repository", "files");
        } else {
            this.delete(expectedStatus, (MultivaluedMap<String, String>)form.asMap(), "projects", projectId, "repository", "files", this.urlEncode(filePath));
        }
    }

    public File getRawFile(Integer projectId, String commitOrBranchName, String filepath, File directory) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", commitOrBranchName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", projectId, "repository", "files", this.urlEncode(filepath), "raw");
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = new File(filepath).getName();
            File file = new File(directory, filename);
            InputStream in = (InputStream)response.readEntity(InputStream.class);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
    }

    public InputStream getRawFile(Integer projectId, String commitOrBranchName, String filepath) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", commitOrBranchName, true);
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", projectId, "repository", "files", this.urlEncode(filepath), "raw");
        return (InputStream)response.readEntity(InputStream.class);
    }

    private Form createForm(RepositoryFile file, String branchName, String commitMessage) {
        Form form = new Form();
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            this.addFormParam(form, "file_path", file.getFilePath(), true);
            this.addFormParam(form, "branch_name", branchName, true);
        } else {
            this.addFormParam(form, "branch", branchName, true);
        }
        this.addFormParam(form, "encoding", file.getEncoding(), false);
        String content = file.getContent();
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        form.param("content", content);
        this.addFormParam(form, "commit_message", commitMessage, true);
        return form;
    }
}

