/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.CommitsApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.DeployKeysApi;
import org.gitlab4j.api.EventsApi;
import org.gitlab4j.api.GitLabApiClient;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GroupApi;
import org.gitlab4j.api.HealthCheckApi;
import org.gitlab4j.api.IssuesApi;
import org.gitlab4j.api.JobApi;
import org.gitlab4j.api.LabelsApi;
import org.gitlab4j.api.LicensesApi;
import org.gitlab4j.api.MarkdownApi;
import org.gitlab4j.api.MergeRequestApi;
import org.gitlab4j.api.MilestonesApi;
import org.gitlab4j.api.NamespaceApi;
import org.gitlab4j.api.NotesApi;
import org.gitlab4j.api.NotificationSettingsApi;
import org.gitlab4j.api.PipelineApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.ProtectedBranchesApi;
import org.gitlab4j.api.RepositoryApi;
import org.gitlab4j.api.RepositoryFileApi;
import org.gitlab4j.api.RunnersApi;
import org.gitlab4j.api.ServicesApi;
import org.gitlab4j.api.SessionApi;
import org.gitlab4j.api.SnippetsApi;
import org.gitlab4j.api.SystemHooksApi;
import org.gitlab4j.api.TagsApi;
import org.gitlab4j.api.UserApi;
import org.gitlab4j.api.WikisApi;
import org.gitlab4j.api.models.OauthTokenResponse;
import org.gitlab4j.api.models.Session;
import org.gitlab4j.api.models.User;
import org.gitlab4j.api.models.Version;
import org.gitlab4j.api.utils.Oauth2LoginStreamingOutput;
import org.gitlab4j.api.utils.SecretString;

public class GitLabApi {
    private static final Logger LOG = Logger.getLogger(GitLabApi.class.getName());
    public static final int DEFAULT_PER_PAGE = 100;
    private static final Map<Optional<?>, GitLabApiException> optionalExceptionMap = Collections.synchronizedMap(new WeakHashMap());
    GitLabApiClient apiClient;
    private ApiVersion apiVersion;
    private String gitLabServerUrl;
    private Map<String, Object> clientConfigProperties;
    private int defaultPerPage = 100;
    private Session session;
    private CommitsApi commitsApi;
    private DeployKeysApi deployKeysApi;
    private EventsApi eventsApi;
    private GroupApi groupApi;
    private HealthCheckApi healthCheckApi;
    private IssuesApi issuesApi;
    private JobApi jobApi;
    private LabelsApi labelsApi;
    private LicensesApi licensesApi;
    private MarkdownApi markdownApi;
    private MergeRequestApi mergeRequestApi;
    private MilestonesApi milestonesApi;
    private NamespaceApi namespaceApi;
    private NotesApi notesApi;
    private NotificationSettingsApi notificationSettingsApi;
    private PipelineApi pipelineApi;
    private ProjectApi projectApi;
    private ProtectedBranchesApi protectedBranchesApi;
    private RepositoryApi repositoryApi;
    private RepositoryFileApi repositoryFileApi;
    private RunnersApi runnersApi;
    private ServicesApi servicesApi;
    private SessionApi sessionApi;
    private SnippetsApi snippetsApi;
    private SystemHooksApi systemHooksApi;
    private TagsApi tagsApi;
    private UserApi userApi;
    private WikisApi wikisApi;

    public static final Logger getLogger() {
        return LOG;
    }

    public final GitLabApi duplicate() {
        Integer sudoUserId = this.getSudoAsId();
        GitLabApi gitLabApi = new GitLabApi(this.apiVersion, this.gitLabServerUrl, this.getTokenType(), this.getAuthToken(), this.getSecretToken(), this.clientConfigProperties);
        if (sudoUserId != null) {
            gitLabApi.apiClient.setSudoAsId(sudoUserId);
        }
        if (this.getIgnoreCertificateErrors()) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        gitLabApi.defaultPerPage = this.defaultPerPage;
        return gitLabApi;
    }

    @Deprecated
    public static GitLabApi oauth2Login(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, null, null, false);
    }

    public static GitLabApi oauth2Login(String url, String username, CharSequence password) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, null, null, false);
    }

    public static GitLabApi oauth2Login(String url, String username, char[] password) throws GitLabApiException {
        try (SecretString secretPassword = new SecretString(password);){
            GitLabApi gitLabApi = GitLabApi.oauth2Login(ApiVersion.V4, url, username, secretPassword, null, null, false);
            return gitLabApi;
        }
    }

    @Deprecated
    public static GitLabApi oauth2Login(String url, String username, String password, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, null, null, ignoreCertificateErrors);
    }

    public static GitLabApi oauth2Login(String url, String username, CharSequence password, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, null, null, ignoreCertificateErrors);
    }

    public static GitLabApi oauth2Login(String url, String username, char[] password, boolean ignoreCertificateErrors) throws GitLabApiException {
        try (SecretString secretPassword = new SecretString(password);){
            GitLabApi gitLabApi = GitLabApi.oauth2Login(ApiVersion.V4, url, username, secretPassword, null, null, ignoreCertificateErrors);
            return gitLabApi;
        }
    }

    @Deprecated
    public static GitLabApi oauth2Login(String url, String username, String password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, secretToken, clientConfigProperties, ignoreCertificateErrors);
    }

    public static GitLabApi oauth2Login(String url, String username, CharSequence password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.oauth2Login(ApiVersion.V4, url, username, password, secretToken, clientConfigProperties, ignoreCertificateErrors);
    }

    public static GitLabApi oauth2Login(String url, String username, char[] password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        try (SecretString secretPassword = new SecretString(password);){
            GitLabApi gitLabApi = GitLabApi.oauth2Login(ApiVersion.V4, url, username, secretPassword, secretToken, clientConfigProperties, ignoreCertificateErrors);
            return gitLabApi;
        }
    }

    public static GitLabApi oauth2Login(ApiVersion apiVersion, String url, String username, char[] password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        try (SecretString secretPassword = new SecretString(password);){
            GitLabApi gitLabApi = GitLabApi.oauth2Login(apiVersion, url, username, secretPassword, secretToken, clientConfigProperties, ignoreCertificateErrors);
            return gitLabApi;
        }
    }

    public static GitLabApi oauth2Login(ApiVersion apiVersion, String url, String username, CharSequence password, String secretToken, Map<String, Object> clientConfigProperties, boolean ignoreCertificateErrors) throws GitLabApiException {
        if (username == null || username.trim().length() == 0) {
            throw new IllegalArgumentException("both username and email cannot be empty or null");
        }
        GitLabApi gitLabApi = new GitLabApi(ApiVersion.OAUTH2_CLIENT, url, (String)null);
        if (ignoreCertificateErrors) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        try (Oauth2LoginStreamingOutput stream = new Oauth2LoginStreamingOutput(username, password);){
            class Oauth2Api
            extends AbstractApi {
                Oauth2Api(GitLabApi gitlabApi) {
                    super(gitlabApi);
                }
            }
            Response response = new Oauth2Api(gitLabApi).post(Response.Status.OK, stream, "application/json", "oauth", "token");
            OauthTokenResponse oauthToken = (OauthTokenResponse)response.readEntity(OauthTokenResponse.class);
            gitLabApi = new GitLabApi(apiVersion, url, Constants.TokenType.ACCESS, oauthToken.getAccessToken(), secretToken, clientConfigProperties);
            if (ignoreCertificateErrors) {
                gitLabApi.setIgnoreCertificateErrors(true);
            }
            GitLabApi gitLabApi2 = gitLabApi;
            return gitLabApi2;
        }
    }

    @Deprecated
    public static GitLabApi login(ApiVersion apiVersion, String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(apiVersion, url, username, password, false);
    }

    @Deprecated
    public static GitLabApi login(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(ApiVersion.V4, url, username, password, false);
    }

    @Deprecated
    public static GitLabApi login(ApiVersion apiVersion, String url, String username, String password, boolean ignoreCertificateErrors) throws GitLabApiException {
        GitLabApi gitLabApi = new GitLabApi(apiVersion, url, (String)null);
        if (ignoreCertificateErrors) {
            gitLabApi.setIgnoreCertificateErrors(true);
        }
        try {
            SessionApi sessionApi = gitLabApi.getSessionApi();
            Session session = sessionApi.login(username, null, password);
            gitLabApi = new GitLabApi(apiVersion, url, session);
            if (ignoreCertificateErrors) {
                gitLabApi.setIgnoreCertificateErrors(true);
            }
        }
        catch (GitLabApiException gle) {
            if (gle.getHttpStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                throw gle;
            }
            gitLabApi = GitLabApi.oauth2Login(apiVersion, url, username, password, null, null, ignoreCertificateErrors);
        }
        return gitLabApi;
    }

    @Deprecated
    public static GitLabApi login(String url, String username, String password, boolean ignoreCertificateErrors) throws GitLabApiException {
        return GitLabApi.login(ApiVersion.V4, url, username, password, ignoreCertificateErrors);
    }

    @Deprecated
    public static GitLabApi create(String url, String username, String password) throws GitLabApiException {
        return GitLabApi.login(url, username, password);
    }

    @Deprecated
    public Session getSession() {
        return this.session;
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(apiVersion, hostUrl, tokenType, authToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken) {
        this(apiVersion, hostUrl, privateToken, null);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, null);
    }

    public GitLabApi(String hostUrl, String privateToken) {
        this(ApiVersion.V4, hostUrl, privateToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Session session) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, session.getPrivateToken(), null);
        this.session = session;
    }

    public GitLabApi(String hostUrl, Session session) {
        this(ApiVersion.V4, hostUrl, session);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(apiVersion, hostUrl, tokenType, authToken, secretToken, null);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken) {
        this(apiVersion, hostUrl, privateToken, secretToken, null);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, secretToken);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(apiVersion, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, tokenType, authToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(String hostUrl, String privateToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this(ApiVersion.V4, hostUrl, Constants.TokenType.PRIVATE, privateToken, secretToken, clientConfigProperties);
    }

    public GitLabApi(ApiVersion apiVersion, String hostUrl, Constants.TokenType tokenType, String authToken, String secretToken, Map<String, Object> clientConfigProperties) {
        this.apiVersion = apiVersion;
        this.gitLabServerUrl = hostUrl;
        this.clientConfigProperties = clientConfigProperties;
        this.apiClient = new GitLabApiClient(apiVersion, hostUrl, tokenType, authToken, secretToken, clientConfigProperties);
    }

    public void sudo(String sudoAsUsername) throws GitLabApiException {
        if (sudoAsUsername == null || sudoAsUsername.trim().length() == 0) {
            this.apiClient.setSudoAsId(null);
            return;
        }
        User user = this.getUserApi().getUser(sudoAsUsername);
        if (user == null || user.getId() == null) {
            throw new GitLabApiException("the specified username was not found");
        }
        Integer sudoAsId = user.getId();
        this.apiClient.setSudoAsId(sudoAsId);
    }

    public void unsudo() {
        this.apiClient.setSudoAsId(null);
    }

    public void setSudoAsId(Integer sudoAsId) throws GitLabApiException {
        if (sudoAsId == null) {
            this.apiClient.setSudoAsId(null);
            return;
        }
        User user = this.getUserApi().getUser(sudoAsId);
        if (user == null || !user.getId().equals(sudoAsId)) {
            throw new GitLabApiException("the specified user ID was not found");
        }
        this.apiClient.setSudoAsId(sudoAsId);
    }

    public Integer getSudoAsId() {
        return this.apiClient.getSudoAsId();
    }

    public String getAuthToken() {
        return this.apiClient.getAuthToken();
    }

    public String getSecretToken() {
        return this.apiClient.getSecretToken();
    }

    public Constants.TokenType getTokenType() {
        return this.apiClient.getTokenType();
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public String getGitLabServerUrl() {
        return this.gitLabServerUrl;
    }

    public int getDefaultPerPage() {
        return this.defaultPerPage;
    }

    public void setDefaultPerPage(int defaultPerPage) {
        this.defaultPerPage = defaultPerPage;
    }

    GitLabApiClient getApiClient() {
        return this.apiClient;
    }

    public boolean getIgnoreCertificateErrors() {
        return this.apiClient.getIgnoreCertificateErrors();
    }

    public void setIgnoreCertificateErrors(boolean ignoreCertificateErrors) {
        this.apiClient.setIgnoreCertificateErrors(ignoreCertificateErrors);
    }

    public Version getVersion() throws GitLabApiException {
        class VersionApi
        extends AbstractApi {
            VersionApi(GitLabApi gitlabApi) {
                super(gitlabApi);
            }
        }
        Response response = new VersionApi(this).get(Response.Status.OK, null, "version");
        return (Version)response.readEntity(Version.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitsApi getCommitsApi() {
        if (this.commitsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.commitsApi == null) {
                    this.commitsApi = new CommitsApi(this);
                }
            }
        }
        return this.commitsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployKeysApi getDeployKeysApi() {
        if (this.deployKeysApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.deployKeysApi == null) {
                    this.deployKeysApi = new DeployKeysApi(this);
                }
            }
        }
        return this.deployKeysApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventsApi getEventsApi() {
        if (this.eventsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.eventsApi == null) {
                    this.eventsApi = new EventsApi(this);
                }
            }
        }
        return this.eventsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupApi getGroupApi() {
        if (this.groupApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.groupApi == null) {
                    this.groupApi = new GroupApi(this);
                }
            }
        }
        return this.groupApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HealthCheckApi getHealthCheckApi() {
        if (this.healthCheckApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.healthCheckApi == null) {
                    this.healthCheckApi = new HealthCheckApi(this);
                }
            }
        }
        return this.healthCheckApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssuesApi getIssuesApi() {
        if (this.issuesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.issuesApi == null) {
                    this.issuesApi = new IssuesApi(this);
                }
            }
        }
        return this.issuesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobApi getJobApi() {
        if (this.jobApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.jobApi == null) {
                    this.jobApi = new JobApi(this);
                }
            }
        }
        return this.jobApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelsApi getLabelsApi() {
        if (this.labelsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.labelsApi == null) {
                    this.labelsApi = new LabelsApi(this);
                }
            }
        }
        return this.labelsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicensesApi getLicensesApi() {
        if (this.licensesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.licensesApi == null) {
                    this.licensesApi = new LicensesApi(this);
                }
            }
        }
        return this.licensesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkdownApi getMarkdownApi() {
        if (this.markdownApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.markdownApi == null) {
                    this.markdownApi = new MarkdownApi(this);
                }
            }
        }
        return this.markdownApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeRequestApi getMergeRequestApi() {
        if (this.mergeRequestApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.mergeRequestApi == null) {
                    this.mergeRequestApi = new MergeRequestApi(this);
                }
            }
        }
        return this.mergeRequestApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MilestonesApi getMilestonesApi() {
        if (this.milestonesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.milestonesApi == null) {
                    this.milestonesApi = new MilestonesApi(this);
                }
            }
        }
        return this.milestonesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceApi getNamespaceApi() {
        if (this.namespaceApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.namespaceApi == null) {
                    this.namespaceApi = new NamespaceApi(this);
                }
            }
        }
        return this.namespaceApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotesApi getNotesApi() {
        if (this.notesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.notesApi == null) {
                    this.notesApi = new NotesApi(this);
                }
            }
        }
        return this.notesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationSettingsApi getNotificationSettingsApi() {
        if (this.notificationSettingsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.notificationSettingsApi == null) {
                    this.notificationSettingsApi = new NotificationSettingsApi(this);
                }
            }
        }
        return this.notificationSettingsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipelineApi getPipelineApi() {
        if (this.pipelineApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.pipelineApi == null) {
                    this.pipelineApi = new PipelineApi(this);
                }
            }
        }
        return this.pipelineApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectApi getProjectApi() {
        if (this.projectApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.projectApi == null) {
                    this.projectApi = new ProjectApi(this);
                }
            }
        }
        return this.projectApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectedBranchesApi getProtectedBranchesApi() {
        if (this.protectedBranchesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.protectedBranchesApi == null) {
                    this.protectedBranchesApi = new ProtectedBranchesApi(this);
                }
            }
        }
        return this.protectedBranchesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryApi getRepositoryApi() {
        if (this.repositoryApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.repositoryApi == null) {
                    this.repositoryApi = new RepositoryApi(this);
                }
            }
        }
        return this.repositoryApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryFileApi getRepositoryFileApi() {
        if (this.repositoryFileApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.repositoryFileApi == null) {
                    this.repositoryFileApi = new RepositoryFileApi(this);
                }
            }
        }
        return this.repositoryFileApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunnersApi getRunnersApi() {
        if (this.runnersApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.runnersApi == null) {
                    this.runnersApi = new RunnersApi(this);
                }
            }
        }
        return this.runnersApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicesApi getServicesApi() {
        if (this.servicesApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.servicesApi == null) {
                    this.servicesApi = new ServicesApi(this);
                }
            }
        }
        return this.servicesApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionApi getSessionApi() {
        if (this.sessionApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.sessionApi == null) {
                    this.sessionApi = new SessionApi(this);
                }
            }
        }
        return this.sessionApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemHooksApi getSystemHooksApi() {
        if (this.systemHooksApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.systemHooksApi == null) {
                    this.systemHooksApi = new SystemHooksApi(this);
                }
            }
        }
        return this.systemHooksApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagsApi getTagsApi() {
        if (this.tagsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.tagsApi == null) {
                    this.tagsApi = new TagsApi(this);
                }
            }
        }
        return this.tagsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserApi getUserApi() {
        if (this.userApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.userApi == null) {
                    this.userApi = new UserApi(this);
                }
            }
        }
        return this.userApi;
    }

    protected static final <T> Optional<T> createOptionalFromException(GitLabApiException glae) {
        Optional optional = Optional.empty();
        optionalExceptionMap.put(optional, glae);
        return optional;
    }

    public static final GitLabApiException getOptionalException(Optional<?> optional) {
        return optionalExceptionMap.get(optional);
    }

    public static final <T> T orElseThrow(Optional<T> optional) throws GitLabApiException {
        GitLabApiException glea = GitLabApi.getOptionalException(optional);
        if (glea != null) {
            throw glea;
        }
        return optional.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnippetsApi getSnippetApi() {
        if (this.snippetsApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.snippetsApi == null) {
                    this.snippetsApi = new SnippetsApi(this);
                }
            }
        }
        return this.snippetsApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikisApi getWikisApi() {
        if (this.wikisApi == null) {
            GitLabApi gitLabApi = this;
            synchronized (gitLabApi) {
                if (this.wikisApi == null) {
                    this.wikisApi = new WikisApi(this);
                }
            }
        }
        return this.wikisApi;
    }

    public static enum ApiVersion {
        V3,
        V4,
        OAUTH2_CLIENT;


        public String getApiNamespace() {
            return "/api/" + this.name().toLowerCase();
        }
    }
}

