/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Pipeline;
import org.gitlab4j.api.models.PipelineStatus;

public class PipelineApi
extends AbstractApi
implements Constants {
    public PipelineApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Pipeline> getPipelines(int projectId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "pipelines");
        return (List)response.readEntity((GenericType)new GenericType<List<Pipeline>>(){});
    }

    public List<Pipeline> getPipelines(int projectId, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "pipelines");
        return (List)response.readEntity((GenericType)new GenericType<List<Pipeline>>(){});
    }

    public Pager<Pipeline> getPipelines(int projectId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Pipeline>(this, Pipeline.class, itemsPerPage, null, "projects", projectId, "pipelines");
    }

    public List<Pipeline> getPipelines(int projectId, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("status", (Object)status).withParam("ref", ref).withParam("yaml_errors", yamlErrors).withParam("name", name).withParam("username", username).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "pipelines");
        return (List)response.readEntity((GenericType)new GenericType<List<Pipeline>>(){});
    }

    public List<Pipeline> getPipelines(int projectId, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("status", (Object)status).withParam("ref", ref).withParam("yaml_errors", yamlErrors).withParam("name", name).withParam("username", username).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "pipelines");
        return (List)response.readEntity((GenericType)new GenericType<List<Pipeline>>(){});
    }

    public Pager<Pipeline> getPipelines(int projectId, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("status", (Object)status).withParam("ref", ref).withParam("yaml_errors", yamlErrors).withParam("name", name).withParam("username", username).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort);
        return new Pager<Pipeline>(this, Pipeline.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "pipelines");
    }

    public Pipeline getPipeline(int projectId, int pipelineId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", projectId, "pipelines", pipelineId);
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public Pipeline createPipeline(int projectId, String ref) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", ref);
        Response response = this.post(Response.Status.CREATED, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", projectId, "pipelines"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public Pipeline retryPipelineJob(int projectId, int pipelineId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.OK, formData, new Object[]{"projects", projectId, "pipelines", pipelineId, "retry"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public Pipeline cancelPipelineJobs(int projectId, int pipelineId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.OK, formData, new Object[]{"projects", projectId, "pipelines", pipelineId, "cancel"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }
}

