/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Milestone;

public class MilestonesApi
extends AbstractApi {
    public MilestonesApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Milestone> getMilestones(Integer projectId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public List<Milestone> getMilestones(Integer projectId, int page, int perPage) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", projectId, "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public List<Milestone> getMilestones(Integer projectId, Constants.MilestoneState state) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public List<Milestone> getMilestones(Integer projectId, String search) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public List<Milestone> getMilestones(Integer projectId, Constants.MilestoneState state, String search) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state", (Object)state).withParam("search", search).withParam("per_page", this.getDefaultPerPage());
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "milestones");
        return (List)response.readEntity((GenericType)new GenericType<List<Milestone>>(){});
    }

    public Milestone getMilestone(Integer projectId, int milestoneId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public List<Issue> getIssues(Integer projectId, Integer milestoneId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "milestones", milestoneId, "issues");
        return (List)response.readEntity((GenericType)new GenericType<List<Issue>>(){});
    }

    public List<MergeRequest> getMergeRequest(Integer projectId, Integer milestoneId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        Response response = this.get(Response.Status.OK, this.getDefaultPerPageParam(), "projects", projectId, "milestones", milestoneId, "merge_requests");
        return (List)response.readEntity((GenericType)new GenericType<List<MergeRequest>>(){});
    }

    public Milestone createMilestone(Integer projectId, String title, String description, Date dueDate, Date startDate) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("due_date", dueDate).withParam("start_date", startDate);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", projectId, "milestones"});
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone closeMilestone(Integer projectId, Integer milestoneId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state_event", (Object)Constants.MilestoneState.CLOSE);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone activateMilestone(Integer projectId, Integer milestoneId) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("state_event", (Object)Constants.MilestoneState.ACTIVATE);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }

    public Milestone updateMilestone(Integer projectId, Integer milestoneId, String title, String description, Date dueDate, Date startDate, Constants.MilestoneState milestoneState) throws GitLabApiException {
        if (projectId == null) {
            throw new RuntimeException("projectId cannot be null");
        }
        if (milestoneId == null) {
            throw new RuntimeException("milestoneId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("title", title, true).withParam("description", description).withParam("due_date", dueDate).withParam("start_date", startDate).withParam("state_event", (Object)milestoneState);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", projectId, "milestones", milestoneId);
        return (Milestone)response.readEntity(Milestone.class);
    }
}

